% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnalysisResults-class.R
\name{visualisation-methods-analyses}
\alias{visualisation-methods-analyses}
\alias{plot,AnalysisResults,ANY-method}
\alias{plot.AnalysisResults}
\title{Visualisation methods}
\usage{
\S4method{plot}{AnalysisResults,ANY}(
  x,
  y,
  ...,
  graph = c("default", "ind", "var", "eig", "boxplot", "buckets"),
  add.label = TRUE,
  n.label.var = 10,
  axes = c(1, 2),
  col.ind = NULL,
  xlim = c(0.5, 10),
  ylim = NULL
)
}
\arguments{
\item{x}{An object of class \linkS4class{AnalysisResults}.}

\item{y}{Currently not used.}

\item{...}{Currently not used.}

\item{graph}{A vector specifying what to plot. Allowed values are
\code{"eig"} for the screegraph (PCA), \code{"ind"} for plot of individuals
(PCA and OPLS-DA), \code{"var"} for plot of variables (PCA and OPLS-DA),
\code{"boxplot"} for boxplots of test results and \code{"buckets"} to show
significant or influential buckets on the mean spectrum.
Default value is \code{"default"} (\emph{i.e.,} \code{c("ind", "var")} for
PCA and OPLS-DA and \code{c("boxplot")} for tests).}

\item{add.label}{If \code{TRUE}, labels are added on individual plot.}

\item{n.label.var}{An integer indicating the number of label to add on
variable plot.}

\item{axes}{A numeric vector of length 2 specifying the dimensions to be
plotted for individual and variable plots.}

\item{col.ind}{A character specifying the name of the design variable used
to color the observations by groups for PCA individual plot.}

\item{xlim, ylim}{Boundaries for x and y, respectively.}
}
\value{
\itemize{
\item PCA: a \code{\link[ggplot2]{ggplot}} plot that allows for the
visualisation of PCA results (eigen values, individuals and variables)
\item OPLS-DA: a \code{\link[ggplot2]{ggplot}} plot that allows for the
visualisation of OPLS-DA results (individuals and variables). If
\code{cross.val > 1} in \code{\link{oplsda}}, the best model is plotted.
}
}
\description{
Method available to plot results of analyses in ASICS package.
}
\examples{
# Import quantification results
if (require("ASICSdata", quietly = TRUE)) {
  quantif_path <- system.file("extdata", "results_ASICS.txt",
                              package = "ASICSdata")
  quantification <- read.table(quantif_path, header = TRUE, row.names = 1)

  # Import design
  design <- read.table(system.file("extdata", "design_diabete_example.txt",
                                   package = "ASICSdata"), header = TRUE)
  design$condition <- factor(design$condition)

  # Create object for analysis and remove metabolites with more than 25\% of
  # zeros
  analysis_obj <- formatForAnalysis(quantification,
                                    zero.threshold = 25, design = design)

  # Perform a PCA and plot results
  res_pca <- pca(analysis_obj)
  plot(res_pca)

  # Perform an OPLS-DA and plot results
  res_oplsda <- oplsda(analysis_obj, "condition", orthoI = 1)
  plot(res_oplsda)
}
}
