% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_data.R
\name{createSpectra}
\alias{createSpectra}
\title{Create a \linkS4class{Spectra} object}
\usage{
createSpectra(spectra, norm.method = NULL, norm.params = NULL)
}
\arguments{
\item{spectra}{Data frame with spectra in columns and chemical shifts in
rows. Colnames of this data frame correspond to pure metabolite names and
rownames to chemical shift grid (in ppm).}

\item{norm.method}{Character specifying the normalisation method to use on
spectra ONLY if the \code{\link{importSpectra}} function was not used.}

\item{norm.params}{List containing normalisation parameteres (see
\code{\link{normaliseSpectra}} for details) ONLY if the
\code{\link{importSpectra}} function was not used.}
}
\value{
A \linkS4class{Spectra} object with spectra to quantify.
}
\description{
Create a new spectra object used for quantification.
}
\examples{
current_path <- system.file("extdata", "example_spectra", package = "ASICS")
spectra_data <- importSpectraBruker(current_path)
spectra_obj <- createSpectra(spectra_data)
}
\seealso{
\linkS4class{Spectra}
}
