% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PureLibrary-class.R
\docType{class}
\name{PureLibrary-class}
\alias{PureLibrary-class}
\title{Class \code{PureLibrary}}
\description{
Objects of class \code{PureLibrary} contain a set of pure metabolite NMR
spectra, used as a reference for the quantification. This class is an
extension of the class \linkS4class{Spectra}, with an additional slot
(number of protons for each metabolite) needed for spectrum quantification.
}
\section{Slots}{

\describe{
\item{\code{nb.protons}}{Numeric vector of the number of protons of each pure
metabolite spectra.}
}}

\section{Methods}{

  Multiple methods can be applied on \linkS4class{PureLibrary} objects.
  \itemize{
    \item As usual for S4 object, show and summary methods are available, see
    \link[=summary-methods]{Object summary}
    \item All slots have an accessor \code{get_slot name}, see
    \link[=accessors-methods]{Accessors}
    \item Two objects can be combined or a subset can be extracted, see
    \link[=combineAndSubset-methods]{Combine and subset methods}
    \item All spectra contained in an object can be represented in a plot,
    see \link[=visualisation-methods-spectra]{Visualisation methods}
  }
}

\seealso{
\linkS4class{Spectra}
}
