% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ASICSResults-class.R
\docType{class}
\name{ASICSResults-class}
\alias{ASICSResults-class}
\title{Class \linkS4class{ASICSResults}}
\description{
Objects of class \linkS4class{ASICSResults} contains results of ASICS
quantification method for a set of spectra. This object is an extension of
the class \linkS4class{Spectra}, with additional slots for quantification
results, reconstructed spectra and deformed library.
}
\section{Slots}{

\describe{
\item{\code{sample.name}}{Character vector of sample names.}

\item{\code{ppm.grid}}{Numeric vector of a unique grid (definition domain) for all
spectra (in ppm).}

\item{\code{spectra}}{Numeric matrix of original spectra. Columns contain the spectra
and are in the same order than \code{sample.name}. Rows correspond to points
of \code{ppm.grid}.}

\item{\code{reconstructed.spectra}}{Numeric matrix of reconstructed spectra (in
columns) with estimated concentrations. Columns are in the same order than
\code{sample.name} and rows correspond to points of \code{ppm.grid}.}

\item{\code{quantification}}{Data-frame with identified metabolites and their
relative concentrations.}

\item{\code{deformed.library}}{A data frame containing the deformed library of each
sample.}
}}

\section{Methods}{

  Multiple methods can be applied to \linkS4class{Spectra} objects.
  \itemize{
    \item As usual for S4 object, show and summary methods are available, see
    \link[=summary-methods]{Object summary}
    \item All slots have an accessor \code{get_slot name}, see
    \link[=accessors-methods]{Accessors}
    \item Two objects can be combined or a subset can be extracted, see
    \link[=combineAndSubset-methods]{Combine and subset methods}
    \item All spectra contained in an object can be represented in a plot,
    see \link[=visualisation-methods-spectra]{Visualisation methods}
  }
}

\seealso{
\linkS4class{Spectra}
}
