% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amaretto_vizualize.R
\name{AMARETTO_VisualizeModule}
\alias{AMARETTO_VisualizeModule}
\title{AMARETTO_VisualizeModule}
\usage{
AMARETTO_VisualizeModule(AMARETTOinit, AMARETTOresults, ProcessedData,
  ModuleNr, show_row_names = FALSE, SAMPLE_annotation = NULL,
  ID = NULL, order_samples = NULL)
}
\arguments{
\item{AMARETTOinit}{List output from AMARETTO_Initialize().}

\item{AMARETTOresults}{List output from AMARETTO_Run().}

\item{ProcessedData}{List of processed input data}

\item{ModuleNr}{Module number to visualize}

\item{show_row_names}{If TRUE, row names will be shown on the plot.}

\item{SAMPLE_annotation}{Matrix or Dataframe with sample annotation}

\item{ID}{Column used as sample name}

\item{order_samples}{Order samples in heatmap by mean or by clustering}
}
\value{
result
}
\description{
Function to visualize the gene modules
}
\examples{
data('ProcessedDataLIHC')
AMARETTOinit <- AMARETTO_Initialize(ProcessedData = ProcessedDataLIHC,
                                    NrModules = 2, VarPercentage = 50)

AMARETTOresults <- AMARETTO_Run(AMARETTOinit)

AMARETTO_VisualizeModule(AMARETTOinit = AMARETTOinit,AMARETTOresults = AMARETTOresults,
                         ProcessedData = ProcessedDataLIHC, ModuleNr = 1)
}
