% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFeature.aldex.r
\name{aldex.plotFeature}
\alias{aldex.plotFeature}
\title{Show dispersion of the expected values returned by \code{aldex.effect}}
\usage{
aldex.plotFeature(
  clrData,
  featureName,
  pooledOnly = FALSE,
  densityOnly = FALSE,
  reset.par = FALSE
)
}
\arguments{
\item{clrData}{the output object from \code{aldex.clr}}

\item{featureName}{the name of the feature from the input data}

\item{pooledOnly}{show only the pooled plots, default FALSE, shows all plots}

\item{densityOnly}{show only the density plots, default FALSE includes expected values}

\item{reset.par}{reset the plotting parameter to par(c(1,1)), default FALSE}
}
\description{
\code{aldex.plotFeature} generates density plots showing the dispersion
 of the expected values given in the output from \code{aldex.effect}.
 The expected values are shown in the plots. This is a diagnostic
 visualization to help determine if the expected values are trustworthy
}
\examples{
data(selex)
#subset for efficiency
selex <- selex[1201:1600,]
conds <- c(rep("NS", 7), rep("S", 7))
x <- aldex.clr(selex, conds, mc.samples=4, denom="all")
aldex.plotFeature(x, "S:D:A:D")
}
\references{
Please use the citation given by
 \code{citation(package="ALDEx2")}.
}
\seealso{
\code{\link{aldex.clr}},
 \code{\link{aldex.effect}},
 \code{\link{selex}}
}
\author{
Brandon Lieng, Greg Gloor
}
