\name{AGDEX-package}
\alias{AGDEX-package}
\docType{package}
\title{Agreement of differential expression analysis}

\description{The objective of AGDEX is to evaluate whether the results of a pair of two-group differential expression
analysis comparisons show a level of agreement that is greater than expected if the group labels for each two-group comparison
are randomly assigned.  The agreement is evaluated for the entire transcriptome and (optionally) for a collection of pre-defined
gene-sets.  Additionally, the procedure performs permutation-based differential expression and meta analysis at both gene and gene-set levels 
of the data from each experiment.

\emph{list of main functions:}

 \code{\link{make.dex.set.object}}: a function to generate a list object for \emph{agdex()} function
 
 \code{\link{agdex}}: a function to perform AGDEX analysis
 
 \code{\link{agdex.scatterplot}}: a function to plot the results of AGDEX analysis for visualization
 
 \code{\link{get.gset.result.details}}: a function to obtain gene level detaills for specified one gene-set or multiple gene-sets
 
 \code{\link{write.agdex.result}}: a function to write the AGDEX result to a tab-delimited text file
 
 \code{\link{read.agdex.result}}: a function to read the AGDEX result from an output file written by write.agdex.result
 
 \code{\link{write.agdex.gset.details}}: a function to write a tab-delimited text file with the gene-level details for the results of a gene-set analysis
 
 \code{\link{read.agdex.gset.details}}: a function to read the output file generated by write.agdex.gset.details
 
 
} % end description

\details{


AGDEX combines the differential expression analysis results from a pair of two-group comparisons.   The two comparisons may
utilize different species or platforms.  AGDEX has been used to confirm that new mouse models accurately represent
the transcriptomes of the pediatric brain tumors ependymoma (Johnson et al. 2010) and medulloblastoma (Gibson et al. 2010).  
Pounds et al. (2011) provide a detailed description of the AGDEX procedure.
In summary, AGDEX analysis can perform the following analysis: 
 
 1. identify individual genes that are differentially expressed for each two-group comparison;
 
 2. identify gene-sets that are differentially expressed for each two-group comparison;
 
 3. integrate results across the pair of two-group comparisons to identify differentially expressed genes;
 
 4. integrate results across the pair of two-group comparisons to identify differentially expressed gene-sets;
 
 5. characterize and determine the statistical significance of similarities of differential 
 expression profiles across the pair of two-group comparisons for the entire transcriptome and for specific gene-sets.

\tabular{ll}{
Package: \tab AGDEX\cr
Type: \tab Package\cr
Version: \tab 1.0.4\cr
Date: \tab 2011-8-29\cr
License: \tab GPL (>=2)\cr
LazyLoad: \tab yes\cr
} %end tabular

} %end details

\author{
Stan Pounds <\email{stanley.pounds@stjude.org}>; Cuilan Lani Gao <\email{cuilan.gao@stjude.org}>
}

\references{
 1. S.Pounds, C.Gao, R.Johnson, K.Wright, H.Poppleton, D.Finkelstein, S.leary and R.Gilbertson (2011). 
 A procedure to statistically evaluate agreement of differential expression for cross-species genomics. 
 \emph{Bioinformatics doi: 10.1093/bioinformatics/btr362} (2011).
 
 2. R.Johnson, et al. Cross-species genomics matches driver mutations and cell compartments to model ependymoma. \emph{Nature}, 466, 632-6 (2010).
 
 3. P.Gibson, et al. Subtypes of medulloblastoma have distinct developmental origins.  \emph{Nature}, 468, 1095-99 (2010).
}

