% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenewiseMethod.R
\name{SplitData}
\alias{SplitData}
\title{Selection of samples for training}
\usage{
SplitData(data, ratio = .7, write.to.file = FALSE, train.only = TRUE)
}
\arguments{
\item{data}{matrix; raw counts (genes as rows and samples as columns)}

\item{ratio}{numeric; ratio of the samples to be used for training}

\item{write.to.file}{logical; should the output be written to a file?}

\item{train.only}{logical; if TRUE define only a training dataset, if
FALSE writes both training and validation sets (defaults to TRUE)}
}
\value{
matrix containing raw counts (genes as rows and samples as columns)
}
\description{
\code{SplitData} selects a portion (\code{ratio}) of samples
(columns in \code{data}) to be used as training set
}
\details{
Selects a portion (\code{ratio}) of samples (columns in \code{data})
to be used as training set and writes to file 'training_raw.txt'.
}
