% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenewiseMethod.R
\name{ChooseMethod}
\alias{ChooseMethod}
\title{Method choice per gene}
\usage{
ChooseMethod(real, masked, imputed, write.to.file = TRUE)
}
\arguments{
\item{real}{matrix; original gene expression data, i.e. before masking
(genes as rows and samples as columns)}

\item{masked}{matrix, logical indicating which entries were masked
(genes as rows and samples as columns)}

\item{imputed}{list; list of matrices with imputation results for all
considered methods}

\item{write.to.file}{logical; should the output be written to a file?}
}
\value{
character; best performing method in the training set for each gene
}
\description{
\code{ChooseMethod} determines the method for dropout
imputation based on performance on each gene in training data
}
\details{
The imputed values are compared to the real ones for every masked
entry in \code{real}. The Mean Squared Error
is computed for all masked entries per gene and the method with the best
performance is chosen for each gene.
}
\seealso{
\code{\link{ComputeMSEGenewise}}
}
