/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.classifier.train.validation;

import edu.msu.cme.rdp.classifier.train.LineageSequence;
import edu.msu.cme.rdp.classifier.train.validation.HierarchyTree;
import edu.msu.cme.rdp.classifier.train.validation.ValidationClassificationResult;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class ValidClassificationResultFacade {
    private String seqName;
    private List<String> ancestors;
    private HierarchyTree labeledNode;
    private List<ValidationClassificationResult> rankAssignment;
    private String highestMissedRank = null;

    public ValidClassificationResultFacade(LineageSequence seq, List<ValidationClassificationResult> assignment) {
        this.seqName = seq.getSeqName();
        this.ancestors = seq.getAncestors();
        this.rankAssignment = assignment;
    }

    public String getSeqName() {
        return this.seqName;
    }

    public List<String> getAncestors() {
        return this.ancestors;
    }

    public List<ValidationClassificationResult> getRankAssignment() {
        return this.rankAssignment;
    }

    public boolean isMissed() {
        return this.highestMissedRank != null;
    }

    public void setMissedRank(String missedRank) {
        this.highestMissedRank = missedRank;
    }

    public HierarchyTree getLabeledNode() {
        return this.labeledNode;
    }

    public void setLabeledNode(HierarchyTree n) {
        this.labeledNode = n;
    }

    public String getPath() throws IOException {
        StringBuilder str = new StringBuilder();
        str.append("SEQ: ").append(this.seqName).append("\t");
        if (this.isMissed()) {
            str.append(this.highestMissedRank);
        }
        str.append("\n");
        Iterator<Object> i = this.getAncestors().iterator();
        while (i.hasNext()) {
            str.append((Object)i.next()).append("\t");
        }
        str.append("\n");
        for (ValidationClassificationResult result : this.getRankAssignment()) {
            str.append(result.getBestClass().getName()).append("\t");
        }
        str.append("\n");
        i = this.getRankAssignment().iterator();
        while (i.hasNext()) {
            str.append(((ValidationClassificationResult)i.next()).getNumOfVotes()).append("\t");
        }
        return str.toString();
    }
}

