/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.alignment.pairwise;

import java.util.Collections;
import java.util.List;

public class PairwiseAlignment {
    private String alignedSeqi;
    private String alignedSeqj;
    private List<Integer> scores;
    private int starti;
    private int endi;
    private int startj;
    private int endj;
    private double ident = Double.NaN;

    public PairwiseAlignment(String alignedSeqi, String alignedSeqj, List<Integer> scores, int starti, int endi, int startj, int endj) {
        this.alignedSeqi = alignedSeqi;
        this.alignedSeqj = alignedSeqj;
        this.scores = Collections.unmodifiableList(scores);
        this.starti = starti;
        this.startj = startj;
        this.endi = endi;
        this.endj = endj;
    }

    public String getAlignedSeqi() {
        return this.alignedSeqi;
    }

    public String getAlignedSeqj() {
        return this.alignedSeqj;
    }

    public int getScore() {
        return this.scores.get(this.scores.size() - 1);
    }

    public List<Integer> getScores() {
        return this.scores;
    }

    public int getEndi() {
        return this.endi;
    }

    public int getEndj() {
        return this.endj;
    }

    public int getStarti() {
        return this.starti;
    }

    public int getStartj() {
        return this.startj;
    }

    public double getIdent() {
        return this.ident;
    }

    public void setIdent(double i) {
        this.ident = i;
    }
}

