/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.alignment.hmm;

import edu.msu.cme.rdp.alignment.hmm.MostProbableHCostHMM;
import edu.msu.cme.rdp.alignment.hmm.TSC;
import edu.msu.cme.rdp.alignment.hmm.XSC;
import edu.msu.cme.rdp.alignment.hmm.XSTATES;
import edu.msu.cme.rdp.readseq.SequenceType;
import java.util.Arrays;

public class ProfileHMM {
    static final int NUM_EMISSION_STATES = 2;
    static final int NUM_TRANSITIONS = 7;
    static final int NXSTATES = 5;
    static final int NXTRANS = 2;
    static final int msc = 0;
    static final int isc = 1;
    String version;
    String name;
    SequenceType alphabet;
    double[][] transitions;
    double[][][] emissions;
    double[] compo;
    double[][] xsc = new double[5][2];
    int[] alphaMapping;
    double[] maxMatchEmissions;
    Integer m;
    int k;
    int l;
    private double nj;
    private boolean multihit = false;
    private boolean local = false;
    private boolean normalized;
    private MostProbableHCostHMM hcost;
    private static final double[] aa_bg;

    public ProfileHMM clone() {
        int index;
        ProfileHMM copy = new ProfileHMM();
        copy.version = this.version;
        copy.name = this.name;
        copy.alphabet = this.alphabet;
        copy.m = this.m;
        copy.k = this.k;
        copy.l = this.l;
        copy.nj = this.nj;
        copy.multihit = this.multihit;
        copy.local = this.local;
        copy.alphaMapping = Arrays.copyOf(this.alphaMapping, this.alphaMapping.length);
        if (this.compo != null) {
            copy.compo = Arrays.copyOf(this.compo, this.compo.length);
        }
        copy.transitions = new double[this.transitions.length][];
        for (index = 0; index < this.transitions.length; ++index) {
            copy.transitions[index] = Arrays.copyOf(this.transitions[index], this.transitions[index].length);
        }
        copy.xsc = new double[this.xsc.length][];
        for (index = 0; index < this.xsc.length; ++index) {
            copy.xsc[index] = Arrays.copyOf(this.xsc[index], this.xsc[index].length);
        }
        copy.emissions = new double[this.emissions.length][][];
        for (int i = 0; i < this.emissions.length; ++i) {
            copy.emissions[i] = new double[this.emissions[i].length][];
            for (int j = 0; j < this.emissions[i].length; ++j) {
                copy.emissions[i][j] = Arrays.copyOf(this.emissions[i][j], this.emissions[i][j].length);
            }
        }
        copy.maxMatchEmissions = Arrays.copyOf(this.maxMatchEmissions, this.maxMatchEmissions.length);
        return copy;
    }

    public String getName() {
        return this.name;
    }

    public int M() {
        return this.m;
    }

    public int K() {
        return this.k;
    }

    public double msc(int k, char b) {
        if (this.alphaMapping[b] == -1) {
            throw new IllegalArgumentException("No mapping for " + b);
        }
        return this.emissions[k][this.alphaMapping[b]][0];
    }

    public void rescaleMatchEmission(int k, char b, double scale) {
        this.msc(k, this.alphaMapping[b], this.msc(k, b) * scale);
    }

    public double isc(int k, char b) {
        return this.emissions[k][this.alphaMapping[b]][1];
    }

    public double msc(int k, int b) {
        if (k == 0) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.emissions[k][b][0];
    }

    public double isc(int k, int b) {
        return this.emissions[k][b][1];
    }

    public double tsc(int k, TSC trans) {
        return this.transitions[trans.ordinal()][k];
    }

    public double[] tsc(TSC trans) {
        return this.transitions[trans.ordinal()];
    }

    public double xsc(XSTATES xstate, XSC trans) {
        return this.xsc[xstate.ordinal()][trans.ordinal()];
    }

    public double getMaxMatchEmission(int i) {
        if (this.normalized) {
            return this.maxMatchEmissions[i];
        }
        return 0.0;
    }

    void msc(int k, int i, double val) {
        this.emissions[k][i][0] = val;
        if (val > this.maxMatchEmissions[k]) {
            this.maxMatchEmissions[k] = val;
        }
    }

    void isc(int k, int i, double val) {
        this.emissions[k][i][1] = val;
    }

    void tsc(int k, TSC trans, double val) {
        this.transitions[trans.ordinal()][k] = val;
    }

    public void xsc(XSTATES xstate, XSC trans, double val) {
        this.xsc[xstate.ordinal()][trans.ordinal()] = val;
    }

    void configureGlocal(boolean normalize) {
        int k;
        this.normalized = normalize;
        double Z = StrictMath.log(this.tsc(0, TSC.MD));
        Arrays.fill(this.maxMatchEmissions, 0.0);
        this.tsc(0, TSC.BM, StrictMath.log(1.0 - this.tsc(0, TSC.MD)));
        for (k = 1; k < this.m; ++k) {
            this.tsc(k, TSC.BM, Z + StrictMath.log(this.tsc(k, TSC.DM)));
            Z += StrictMath.log(this.tsc(k, TSC.DD));
        }
        this.tsc(this.m, TSC.BM, Double.NEGATIVE_INFINITY);
        if (this.multihit) {
            throw new RuntimeException("I hate you");
        }
        this.xsc(XSTATES.E, XSC.MOVE, 0.0);
        this.xsc(XSTATES.E, XSC.LOOP, Double.NEGATIVE_INFINITY);
        for (k = 1; k <= this.m; ++k) {
            for (int x = 0; x < this.k; ++x) {
                double val = this.msc(k, x);
                if (normalize) {
                    val /= this.compo[x];
                }
                this.msc(k, x, StrictMath.log(val));
                if (normalize) {
                    this.isc(k, x, 0.0);
                    continue;
                }
                this.isc(k, x, StrictMath.log(this.isc(k, x)));
            }
        }
        for (k = 0; k <= this.m; ++k) {
            for (TSC trans : TSC.values()) {
                if (trans == TSC.BM) continue;
                this.tsc(k, trans, StrictMath.log(this.tsc(k, trans)));
            }
        }
        for (int x = 0; x < this.k; ++x) {
            this.isc(this.m, x, Double.NEGATIVE_INFINITY);
        }
    }

    public void reconfigureLength(int L) {
        double pmove = (2.0 + this.nj) / ((double)(L + 2) + this.nj);
        double ploop = 1.0 - pmove;
        this.xsc(XSTATES.N, XSC.LOOP, StrictMath.log(ploop));
        this.xsc(XSTATES.C, XSC.LOOP, StrictMath.log(ploop));
        this.xsc(XSTATES.J, XSC.LOOP, StrictMath.log(ploop));
        this.xsc(XSTATES.N, XSC.MOVE, StrictMath.log(pmove));
        this.xsc(XSTATES.C, XSC.MOVE, StrictMath.log(pmove));
        this.xsc(XSTATES.J, XSC.MOVE, StrictMath.log(pmove));
        this.l = L;
    }

    public SequenceType getAlphabet() {
        return this.alphabet;
    }

    public MostProbableHCostHMM getHCost() {
        if (this.hcost == null) {
            this.hcost = new MostProbableHCostHMM(this);
        }
        return this.hcost;
    }

    static {
        double[] bg = new double[]{0.0787945, 0.01516, 0.0535222, 0.0668298, 0.0397062, 0.0695071, 0.0229198, 0.0590092, 0.0594422, 0.0963728, 0.0237718, 0.0414386, 0.0482904, 0.0395639, 0.0540978, 0.0683364, 0.0540687, 0.0673417, 0.0114135, 0.0304133};
        aa_bg = bg;
    }
}

