/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.StreamParser;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.IllegalSymbolException;

public class FastaFormat
implements SequenceFormat,
Serializable {
    public static final String PROPERTY_DESCRIPTIONLINE = "description_line";
    private int lineWidth = 60;
    static /* synthetic */ Class class$org$biojava$bio$seq$io$FastaFormat;

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("Fasta");
        SequenceFormat.FORMATS.put((class$org$biojava$bio$seq$io$FastaFormat != null ? class$org$biojava$bio$seq$io$FastaFormat : (class$org$biojava$bio$seq$io$FastaFormat = FastaFormat.class$("org.biojava.bio.seq.io.FastaFormat"))).getName(), hashSet);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected String describeSequence(Sequence sequence) {
        String string = null;
        try {
            string = sequence.getAnnotation().getProperty(PROPERTY_DESCRIPTIONLINE).toString();
        }
        catch (NoSuchElementException noSuchElementException) {
            string = sequence.getName();
        }
        return string;
    }

    public String getDefaultFormat() {
        return "Fasta";
    }

    public Set getFormats() {
        return (Set)SequenceFormat.FORMATS.get(this.getClass().getName());
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public boolean readSequence(BufferedReader bufferedReader, SymbolParser symbolParser, SeqIOListener seqIOListener) throws IllegalSymbolException, IOException, ParseException {
        String string = bufferedReader.readLine();
        if (string == null) {
            throw new IOException("Premature stream end");
        }
        if (!string.startsWith(">")) {
            throw new IOException("Stream does not appear to contain FASTA formatted data: " + string);
        }
        seqIOListener.startSequence();
        String string2 = string.substring(1).trim();
        seqIOListener.addSequenceProperty(PROPERTY_DESCRIPTIONLINE, string2);
        boolean bl = this.readSequenceData(bufferedReader, symbolParser, seqIOListener);
        seqIOListener.endSequence();
        return bl ^ true;
    }

    private boolean readSequenceData(BufferedReader bufferedReader, SymbolParser symbolParser, SeqIOListener seqIOListener) throws IOException, IllegalSymbolException {
        char[] cArray = new char[256];
        boolean bl = false;
        boolean bl2 = false;
        StreamParser streamParser = symbolParser.parseStream(seqIOListener);
        while (!bl) {
            bufferedReader.mark(cArray.length);
            int n = bufferedReader.read(cArray, 0, cArray.length);
            if (n < 0) {
                bl2 = true;
                bl = true;
                continue;
            }
            int n2 = 0;
            int n3 = 0;
            while (!bl && n2 < n && cArray[n2] != '>') {
                n3 = n2;
                while (n3 < n && cArray[n3] != '\n' && cArray[n3] != '\r') {
                    ++n3;
                }
                streamParser.characters(cArray, n2, n3 - n2);
                n2 = n3 + 1;
                while (n2 < n && cArray[n2] == '\n' && cArray[n2] == '\r') {
                    ++n2;
                }
            }
            if (n2 >= n || cArray[n2] != '>') continue;
            bufferedReader.reset();
            if (bufferedReader.skip(n2) != (long)n2) {
                throw new IOException("Couldn't reset to start of next sequence");
            }
            bl = true;
        }
        streamParser.close();
        return bl2;
    }

    public void setLineWidth(int n) {
        this.lineWidth = this.lineWidth;
    }

    public void writeSequence(Sequence sequence, PrintStream printStream) {
        printStream.print(">");
        printStream.println(this.describeSequence(sequence));
        int n = 1;
        while (n <= sequence.length() + 1) {
            int n2 = Math.min(n + this.lineWidth - 1, sequence.length());
            printStream.println(sequence.subStr(n, n2));
            n += this.lineWidth;
        }
    }

    public void writeSequence(Sequence sequence, String string, PrintStream printStream) throws IOException {
    }
}

