## ----eval = FALSE-------------------------------------------------------------
# if (!require("BiocManager"))
#     install.packages("BiocManager")
# BiocManager::install("scQTLtools")

## ----input, message = FALSE---------------------------------------------------
library(scQTLtools)
# gene expression matrix
data(GeneData)
# SeuratObject
data(Seurat_obj)
# load the genotype data
data(SNPData)
data(SNPData2)

## ----createObject_matrix, message = FALSE-------------------------------------
eqtl_matrix <- createQTLObject(
    snpMatrix = SNPData,
    genedata = GeneData,
    biClassify = FALSE,
    species = 'human',
    group = NULL)

## ----createObject_matrix_bi, message = FALSE----------------------------------
eqtl_matrix_bi <- createQTLObject(
    snpMatrix = SNPData,
    genedata = GeneData,
    biClassify = TRUE,
    species = 'human',
    group = NULL)

## ----createObject_seuratobject, message = FALSE-------------------------------
eqtl_seurat <- createQTLObject(
    snpMatrix = SNPData2,
    genedata = Seurat_obj,
    biClassify = FALSE,
    species = 'human',
    group = "celltype")

## ----createObject_sceobject, message = FALSE----------------------------------
# Create a SingleCellExperiment object
library(SingleCellExperiment)
sce <- SingleCellExperiment(assays = list(counts = GeneData))
eqtl_sce <- createQTLObject(
    snpMatrix = SNPData,
    genedata = sce,
    biClassify = FALSE,
    species = 'human',
    group = NULL)

## ----Normalize_matrix, message = FALSE----------------------------------------
eqtl_matrix  <- normalizeGene(
    eQTLObject = eqtl_matrix, 
    method = "logNormalize")

## ----Normalize_sceobject, message = FALSE-------------------------------------
eqtl_sce  <- normalizeGene(
    eQTLObject = eqtl_sce, 
    method = "logNormalize")

## ----filter_matrix, message = FALSE-------------------------------------------
eqtl_matrix <- filterGeneSNP(
    eQTLObject = eqtl_matrix,
    snpNumOfCellsPercent = 2,
    expressionMin = 0,
    expressionNumOfCellsPercent = 2)

## ----filter_seuratobject, message = FALSE-------------------------------------
eqtl_seurat <- filterGeneSNP(
    eQTLObject = eqtl_seurat,
    snpNumOfCellsPercent = 2,
    expressionMin = 0,
    expressionNumOfCellsPercent = 2)

## ----filter_sceobject, message = FALSE----------------------------------------
eqtl_sce <- filterGeneSNP(
    eQTLObject = eqtl_sce,
    snpNumOfCellsPercent = 2,
    expressionMin = 0,
    expressionNumOfCellsPercent = 2)

## ----callQTL1_matrix, message = FALSE-----------------------------------------
eqtl1_matrix <- callQTL(
    eQTLObject = eqtl_matrix,
    gene_ids = NULL,
    downstream = NULL,
    upstream = NULL,
    gene_mart = NULL,
    snp_mart = NULL,
    pAdjustMethod = "bonferroni",
    useModel = "linear",
    pAdjustThreshold = 0.05,
    logfcThreshold = 0.1)

## ----callQTL1_seuratobject, message = FALSE-----------------------------------
eqtl1_seurat <- callQTL(
    eQTLObject = eqtl_seurat,
    gene_ids = NULL,
    downstream = NULL,
    upstream = NULL,
    gene_mart = NULL,
    snp_mart = NULL,
    pAdjustMethod = "bonferroni",
    useModel = "linear",
    pAdjustThreshold = 0.05,
    logfcThreshold = 0.025)

## ----callQTL1_sceobject, message = FALSE--------------------------------------
eqtl1_sce <- callQTL(
    eQTLObject = eqtl_sce,
    gene_ids = NULL,
    downstream = NULL,
    upstream = NULL,
    gene_mart = NULL,
    snp_mart = NULL,
    pAdjustMethod = "bonferroni",
    useModel = "linear",
    pAdjustThreshold = 0.05,
    logfcThreshold = 0.025)

## ----callQTL2_matrix, message = FALSE-----------------------------------------
eqtl2_matrix <- callQTL(
    eQTLObject = eqtl_matrix,
    gene_ids = c("CNN2", 
                "RNF113A", 
                "SH3GL1", 
                "INTS13", 
                "PLAU"),
    downstream = NULL,
    upstream = NULL,
    gene_mart = NULL,
    snp_mart = NULL,
    pAdjustMethod = "bonferroni",
    useModel = "poisson",
    pAdjustThreshold = 0.05,
    logfcThreshold = 0.1)

## ----callQTL3_matrix, message = FALSE-----------------------------------------
eqtl3_matrix <- callQTL(
    eQTLObject = eqtl_matrix,
    gene_ids = NULL,
    downstream = -9e7,
    upstream = 2e8,
    gene_mart = NULL,
    snp_mart = NULL,
    pAdjustMethod = "bonferroni",
    useModel = "poisson",
    pAdjustThreshold = 0.05,
    logfcThreshold = 0.05)

## ----visualizeQTL_matrix, message = FALSE-------------------------------------
visualizeQTL(
    eQTLObject = eqtl1_matrix,
    SNPid = "1:632647",
    Geneid = "RPS27",
    groupName = NULL,
    plottype = "QTLplot",
    removeoutlier = TRUE)

## ----visualizeQTL_seuratobject, message = FALSE-------------------------------
visualizeQTL(
    eQTLObject = eqtl1_seurat,
    SNPid = "1:632647",
    Geneid = "RPS27",
    groupName = NULL,
    plottype = "QTLplot",
    removeoutlier = TRUE)

## ----visualizeQTL_seuratobject_groupName, message = FALSE---------------------
visualizeQTL(
    eQTLObject = eqtl1_seurat,
    SNPid = "1:632647",
    Geneid = "RPS27",
    groupName = "GMP",
    plottype = "QTLplot",
    removeoutlier = TRUE)

## ----visualizeQTL_sceobject, message = FALSE----------------------------------
visualizeQTL(
    eQTLObject = eqtl1_sce,
    SNPid = "1:632647",
    Geneid = "RPS27",
    groupName = NULL,
    plottype = "boxplot",
    removeoutlier = TRUE)

## -----------------------------------------------------------------------------
sessionInfo()

