/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.classifier.io;

import edu.msu.cme.rdp.classifier.GenusWordConditionalProb;
import edu.msu.cme.rdp.classifier.TrainingDataException;
import edu.msu.cme.rdp.classifier.utils.HierarchyVersion;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.StringTokenizer;

public class GenusWordProbFileParser {
    public static HierarchyVersion createGenusWordProbList(Reader r, List<GenusWordConditionalProb> aList, HierarchyVersion version) throws IOException, TrainingDataException {
        BufferedReader reader = new BufferedReader(r);
        String line = reader.readLine();
        if (line != null) {
            HierarchyVersion thisVersion = new HierarchyVersion(line);
            int trainsetNo = thisVersion.getTrainsetNo();
            if (thisVersion.getVersion() == null) {
                throw new TrainingDataException("Error: There is no version information in the probabilityList file");
            }
            if (version == null) {
                version = thisVersion;
            } else if (!version.getVersion().equals(thisVersion.getVersion()) || version.getTrainsetNo() != thisVersion.getTrainsetNo()) {
                throw new TrainingDataException("Error: The version information in the probabilityList file is different from the version of the other training files.");
            }
        }
        while ((line = reader.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(line, "\t");
            if (st.countTokens() != 2) {
                throw new TrainingDataException("\nError: " + line + " does not have exact two numbers");
            }
            try {
                int genusIndex = Integer.parseInt(st.nextToken());
                float prob = Float.parseFloat(st.nextToken());
                GenusWordConditionalProb genusProb = new GenusWordConditionalProb(genusIndex, prob);
                aList.add(genusProb);
            }
            catch (NumberFormatException e) {
                reader.close();
                throw new TrainingDataException("\nError: The value for genusIndex or word conditional probability is not a number at line : " + line);
            }
        }
        reader.close();
        return version;
    }
}

