## ----eval = TRUE, echo=FALSE, results="hide", message = FALSE, warning = FALSE----
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>"
)
suppressPackageStartupMessages({
    library(HiCool)
})

## ----eval = FALSE-------------------------------------------------------------
# x <- HiCool(
#     r1 = '<PATH-TO-R1.fq.gz>',
#     r2 = '<PATH-TO-R2.fq.gz>',
#     restriction = '<RE1(,RE2)>',
#     binning = "<minimum resolution>",
#     genome = '<GENOME_ID>'
# )

## -----------------------------------------------------------------------------
library(HiCool)
hcf <- HiCool(
    r1 = HiContactsData::HiContactsData(sample = 'yeast_wt', format = 'fastq_R1'), 
    r2 = HiContactsData::HiContactsData(sample = 'yeast_wt', format = 'fastq_R2'), 
    restriction = 'DpnII,HinfI', 
    binning = 1000, 
    genome = 'R64-1-1', 
    output = './HiCool/'
)

## -----------------------------------------------------------------------------
hcf
S4Vectors::metadata(hcf)

## ----echo = FALSE-------------------------------------------------------------
## HiCool/
## |-- sample^mapped-R64-1-1^55IONQ.html
## |-- logs
## |   |-- sample^mapped-R64-1-1^55IONQ.log
## |-- matrices
## |   |-- sample^mapped-R64-1-1^55IONQ.mcool
## |-- pairs
## |   |-- sample^mapped-R64-1-1^55IONQ.pairs
## `-- plots
##     |-- sample^mapped-R64-1-1^55IONQ_event_distance.pdf
##     |-- sample^mapped-R64-1-1^55IONQ_event_distribution.pdf

## ----session------------------------------------------------------------------
sessionInfo()

