% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tRNA_class.R
\name{tRNA_class}
\alias{tRNA_class}
\title{Classify tsRNA/tRFs from  PAC object}
\usage{
tRNA_class(PAC, map, terminal = 5)
}
\arguments{
\item{PAC}{PAC-list object.}

\item{map}{Map object with loop annotations generated by
\code{\link[seqpac]{PAC_mapper}} followed by
\code{\link[seqpac]{map_rangetype}} functions. Note, only full length
reference tRNAs annotated with 3 loops in the ss file (see:
\code{\link[seqpac]{map_rangetype}}) are used in the classifications.
Explanation: sometimes tRNAscan-SE scans results in ss files with
incomplete secondary structures with either more or fewer loops than the D,
T and anticodon loops found in canonical tRNAs. Such tRNAs will be removed
from the analysis.}

\item{terminal}{Integer setting the terminal tolerance. Example, when
terminal is set to 5 (default) sequenced reads starting within the 5 first
nucleotides of the full-length tRNA reference will be classifed as 5'. If
it instead ends within the 5 last nucleotides of the full-length tRNA
reference it will be classified as 3'. If a read neither starts nor ends
within the terminal threshold it will be classified as i' (internal). Note,
for tsRNA/tRF classification we recommend a threshold of terminal=2 (not
default). Advisably, however, \code{\link[seqpac]{PAC_mapper}} runs with
N_up = "NNN" and N_down = "NNN" when mapping tsRNA/tRFs. Thus, the default
threshold of 5 is used when full-length tRNAs has been extended with NNN
up- and downstream to compensate for possible fragments from mature tRNAs
(3+2). Always double check the exact fragment using
\code{\link[seqpac]{PAC_covplot}}.}
}
\value{
Merged PAC object with an extended Anno table containing the
  tRF/tsRNA classifications.
}
\description{
Classifying tRFs/tsRNA into 5'-tRF/halves, 3'-tRFs/halves, i'-tRFs/halves, as
well as acceptor and decoder isotypes.
}
\details{
Given a map object with range types generated by
\code{\link[seqpac]{PAC_mapper}} followed by
\code{\link[seqpac]{map_rangetype}} functions, sequences in a PAC object are
classified according the terminals (5'/3'/i'), anticodon loop (half/tRF), and
isotype (decoder/acceptor) of the full length tRNA.
}
\examples{

# Important: See ?PAC_trna on how to do tRNA analysis using Seqpac 

#'###########################################################
### tRNA classification in seqpac 
# (More details see vignette and manuals.)

##-------------------------------##
## Setup environment for testing ##

# First create an annotation blank PAC with group means
load(system.file("extdata", "drosophila_sRNA_pac_filt_anno.Rdata", 
                package = "seqpac", mustWork = TRUE))
anno(pac) <- anno(pac)[,1, drop=FALSE]
pac_trna <- PAC_summary(pac, norm = "cpm", type = "means", 
                       pheno_target=list("stage"), merge_pac = TRUE)


# Then load paths to example trna ref and ss files
trna_ref <- system.file("extdata/trna2", "tRNA2.fa", 
                       package = "seqpac", mustWork = TRUE)

ss_file <- system.file("extdata/trna2", "tRNA2.ss",
                      package = "seqpac", mustWork = TRUE)


##--------------------------------------##
## Create a map object using PAC_mapper ##
map_object <- PAC_mapper(pac_trna, input=trna_ref, 
                        N_up = "NNN", N_down = "NNN",
                        mismatches=0, threads=2, 
                        report_string=TRUE, override = TRUE)
# Warning: override = TRUE, will remove everything in temporary output path.
# Note: bowtie indexes are not needed for PAC_mapper.


##-------------------------------------------##
## Classify tRNA fragment with map_rangetype ## 

# Classify according to loop structure using ss file provided with seqpac
map_object_ss <- map_rangetype(map_object, type="ss", ss=ss_file, 
                              min_loop_width=4)          
# Note 1: You may download your own ss file at for example GtRNAdb
# Note 2: The ss file must match the reference used in creating the map_object

map_object_ss[[1]]

}
\seealso{
\url{https://github.com/OestLab/seqpac} for updates on the current
  package.

Other PAC analysis: 
\code{\link{PAC_covplot}()},
\code{\link{PAC_deseq}()},
\code{\link{PAC_filter}()},
\code{\link{PAC_filtsep}()},
\code{\link{PAC_gtf}()},
\code{\link{PAC_jitter}()},
\code{\link{PAC_mapper}()},
\code{\link{PAC_nbias}()},
\code{\link{PAC_norm}()},
\code{\link{PAC_pca}()},
\code{\link{PAC_pie}()},
\code{\link{PAC_saturation}()},
\code{\link{PAC_sizedist}()},
\code{\link{PAC_stackbar}()},
\code{\link{PAC_summary}()},
\code{\link{PAC_trna}()},
\code{\link{as.PAC}()},
\code{\link{filtsep_bin}()},
\code{\link{map_rangetype}()}
}
\concept{PAC analysis}
