% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqpac_S4classes.R
\name{as.reanno}
\alias{as.reanno}
\title{Converts an S3 reanno into a S4 reanno}
\usage{
as.reanno(from)
}
\arguments{
\item{from}{S3 reanno object.}
}
\value{
An S4 reanno object.
}
\description{
\code{as.reanno} Converts an S3 reanno object (list) to an S4 reanno object
}
\details{
Seqpac comes with two versions of the reanno object, either S4 or S3. The S3 
is simply a list where each object can be received using the $-sign. The S4
version is a newer type of R object with predefined slots, that is received
using the @-sign. This function converts an S3 reanno object (list) to an S4 
object. You can also use the S4 coercion method "as" to turn an S4 into
an S3. See examples below.
}
\examples{

##### Create an reanno object

##  First load a PAC- object

load(system.file("extdata", "drosophila_sRNA_pac_filt_anno.Rdata", 
                   package = "seqpac", mustWork = TRUE))
 
##  Then specify paths to fasta references
# If you are having problem see the vignette small RNA guide for more info.
 
 trna_file <- system.file("extdata/trna", "tRNA.fa", 
                          package = "seqpac", mustWork = TRUE)
 trna_dir <- dirname(trna_file)
 
 if(!sum(stringr::str_count(list.files(trna_dir), ".ebwt")) ==6){     
     Rbowtie::bowtie_build(trna_file, 
                           outdir=trna_dir, 
                           prefix="tRNA", force=TRUE)
                           }
 
 ref_paths <- list(trna= trna_file)
                                    
##  Add output path of your choice.
# Here we use the R temporary folder depending on platform
 output <- paste0(tempdir(),"/seqpac/test")

## Make sure it is empty (otherwise you will be prompted for a question)
out_fls  <- list.files(output, recursive=TRUE)
closeAllConnections()
suppressWarnings(file.remove(paste(output, out_fls, sep="/")))

##  Then map your PAC-object against the fasta references
 map_reanno(pac, input=ref_paths, output=output,
               type="internal", mismatches=0,  import="biotype", 
               threads=2, keep_temp=FALSE, override=TRUE)

##  Then import and generate a reanno-object of the temporary bowtie-files
reanno <- make_reanno(output, PAC=pac, mis_fasta_check = TRUE)
                                    
## Now make some search terms against reference names to create shorter names
# Theses can be used to create factors in downstream analysis
# One search hit (regular expressions) gives one new short name 
bio_search <- list(trna =c("_tRNA", "mt:tRNA"))
 
 
## You can merge directly with your PAC-object by adding your original 
# PAC-object, that you used with map_reanno, to merge_pac option.
 pac <- add_reanno(reanno, bio_search=bio_search, 
                       type="biotype", bio_perfect=FALSE, 
                       mismatches = 0, merge_pac=pac)
                       
                       
## Turn your S3 list to an S4 reanno-object
isS4(reanno)
names(reanno)
table(overview(reanno)$trna)
 
reanno_s3 <- as(reanno, "list")
isS4(reanno_s3)   

# Turns S3 reanno object into a S4 
reanno_s4 <- as.reanno(reanno_s3)
isS4(reanno_s4) 
 
}
\seealso{
\url{https://github.com/OestLab/seqpac} for updates on the current
  package.

Other PAC reannotation: 
\code{\link{PAC_annotate}()},
\code{\link{add_reanno}()},
\code{\link{import_reanno}()},
\code{\link{make_conv}()},
\code{\link{make_reanno}()},
\code{\link{map_reanno}()},
\code{\link{simplify_reanno}()}
}
\concept{PAC reannotation}
