% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PAC_pca.R
\name{PAC_pca}
\alias{PAC_pca}
\title{Principle component analysis with scatterplots from PAC}
\usage{
PAC_pca(
  PAC,
  norm = "counts",
  style = "pheno",
  graphs = TRUE,
  pheno_target = NULL,
  anno_target = NULL,
  labels = NULL
)
}
\arguments{
\item{PAC}{PAC-list object.}

\item{norm}{Character what data to plot. (default="counts")}

\item{style}{Character indicating what type of pca and plot to be drawn. When
style="pheno" then results will be drawn from a sample perspective, while
if style="anno" then results will be presented from a sequence perspective.
If style="both" then a bi-plot will be drawn, representing both pheno and anno
features. Note, the 1st object (target column name) in the pheno_target or
anno_taget can be used to specifically highlight sample and sequence groups
(see below).}

\item{graphs}{Logical whether or not scatter plots should be plotted.
(default=TRUE)}

\item{pheno_target}{List with: 1st object being a character vector of target
column(s) in Pheno, 2nd object being a character vector of the target
group(s) in the target column (1st object). The 1st object also control
group colors when style="pheno" or "both". (default=NULL)}

\item{anno_target}{List with: 1st object being a character vector of target
column(s) in Anno, 2nd object being a character vector of the target
features(s) in the target column (1st object). The 1st object also control
sequence feature colors when style="anno". (default=NULL)}

\item{labels}{If labels="sample", then points will be labeled with the names
rownames in pheno(PAC) or anno(PAC) depending on style="pheno" or
style="anno", respectively. Point labels can also be manually provided as a
character vector in the same length as the intended target. As default,
labels=NULL where only point are plotted.}
}
\value{
A PCA list object generated by the PCA function in the FactoMineR
 package
}
\description{
\code{PAC_pca} PAC principle component analysis.
}
\details{
Given a PAC object the function will perform a principle component analysis by
calling the PCA function in the FactoMineR package, and then plot scatter
plots with the fviz_pca functions of the factoextra package.
}
\examples{

# Load a PAC-object 
load(system.file("extdata", "drosophila_sRNA_pac_filt_anno.Rdata", 
                  package = "seqpac", mustWork = TRUE))

# Simple sample counts pca and scatterplots with no groupings: 
pca_cnt <- PAC_pca(pac, norm="counts")

# Sample cpm pca and scatterplots with color groupings from 
# pheno(PAC)$style column:    
pca_cpm <- PAC_pca(pac, norm="cpm", style="pheno", 
                   pheno_target=list("stage"))

# Same but with or without text labels: 
pca_cpm_lab <- PAC_pca(pac, norm="cpm", style="pheno", 
                       pheno_target=list("stage"), labels="samples")
pca_cpm_lab2 <- PAC_pca(pac, norm="cpm", style="pheno", 
                        pheno_target=list("stage"), 
                        labels=pheno(pac)$batch)

# Cpm pca with anno(PAC) sequence features instead of Pheno samples and 
# restricted to read size 20-22:
pca_cpm_anno <- PAC_pca(pac, norm="cpm", style="anno", 
                        anno_target=list("Size", 20:22))

# Cpm pca as biplot:
pca_cpm_bi <- PAC_pca(pac, norm="cpm", style="both", 
                      pheno_target=list("stage"))

# Plot individual graphs
pca_cpm_bi$graphs[[1]]
pca_cpm_lab$graphs[[1]]
pca_cpm_anno$graphs[[3]]

# Extract pca output
pca_cpm_anno$pca

}
\seealso{
\url{https://github.com/OestLab/seqpac} for updates on the current package.

Other PAC analysis: 
\code{\link{PAC_covplot}()},
\code{\link{PAC_deseq}()},
\code{\link{PAC_filter}()},
\code{\link{PAC_filtsep}()},
\code{\link{PAC_gtf}()},
\code{\link{PAC_jitter}()},
\code{\link{PAC_mapper}()},
\code{\link{PAC_nbias}()},
\code{\link{PAC_norm}()},
\code{\link{PAC_pie}()},
\code{\link{PAC_saturation}()},
\code{\link{PAC_sizedist}()},
\code{\link{PAC_stackbar}()},
\code{\link{PAC_summary}()},
\code{\link{PAC_trna}()},
\code{\link{as.PAC}()},
\code{\link{filtsep_bin}()},
\code{\link{map_rangetype}()},
\code{\link{tRNA_class}()}
}
\concept{PAC analysis}
