% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PAC_annotate.R
\name{PAC_annotate}
\alias{PAC_annotate}
\title{Wrapper for annotation of PAC object}
\usage{
PAC_annotate(genome = NULL, biotype = NULL, output = NULL, PAC)
}
\arguments{
\item{genome}{Character indicating path to reference genome in fasta (.fa) 
format to use for annotation by \code{\link{map_reanno}} with import="genome". 
Reference genome should have a bowtie index, please see 
??Rbowtie::bowtie_build for instructions. Default=NULL, where no genome-based
mapping will be performed.}

\item{biotype}{Character indicating path to reference fasta (.fa) file for 
bioinformatic annotation by \code{\link{map_reanno}} with import="biotype". 
This wrapper is justerad to the ncRNA fasta from Ensembl, with biotypes such 
as rRNA, tRNA and miRNA available. Reference fasta should have a bowtie index, 
please see ??Rbowtie::bowtie_build for instructions. Within this wrapper, a 
hierarcy is made with \code{\link{simplify_reanno}}, with the following 
hiearchy: rRNA, miRNA, tRNA, snoRNA, snRNA. If other references wish to be 
used, please run each function separately. Default=NULL, where no biotype-
based mapping will be performed.}

\item{output}{Output directory for summarized annotation 
information (.Rdata files) created by map_reanno.}

\item{PAC}{PAC-object used for mapping.}
}
\value{
PAC object with annotation information retrieved from mapping
}
\description{
\code{PAC_annotate} Annotates the provided PAC object to a genome or biotypes
}
\details{
Given the path to either a reference genome, a biotype reference or both, 
PAC_annotate will wrap around all reanno-functions (\code{\link{map_reanno}},
 \code{\link{make_reanno}}, and \code{\link{add_reanno}}) to annotate the PAC
 object. This wrapper comes with the caveat that it uses default values in 
 most functions and is finetuned towards basic biotype annotation against the
 Ensembl ncRNA fasta reference. If that does not suit your analysis, we 
 recommend you to run each function on its own for its full potential!
}
\examples{

###########################################################

genome <- system.file("extdata/mycoplasma_genome", "mycoplasma.fa",
                     package = "seqpac", mustWork = TRUE)
genome_dir <- dirname(genome)

if(!sum(stringr::str_count(list.files(genome_dir), ".ebwt")) ==6){
  Rbowtie::bowtie_build(genome,
                        outdir=genome_dir,
                        prefix="mycoplasma", force=TRUE)
}

##  load a PAC-object and remove previous mapping from anno:
load(system.file("extdata", "drosophila_sRNA_pac_filt_anno.Rdata",
                 package = "seqpac", mustWork = TRUE))
anno(pac) <- anno(pac)[,1, drop = FALSE]

output <- paste0(tempdir(),"/seqpac/test")

#as we only test this against the mycoplasma genome,
#we expect a small overlap (0.03\%)

pac <- PAC_annotate(PAC=pac,
                    genome = genome,
                    output = output)

}
\seealso{
\url{https://github.com/OestLab/seqpac} for updates on the current
  package.

Other PAC reannotation: 
\code{\link{add_reanno}()},
\code{\link{as.reanno}()},
\code{\link{import_reanno}()},
\code{\link{make_conv}()},
\code{\link{make_reanno}()},
\code{\link{map_reanno}()},
\code{\link{simplify_reanno}()}
}
\concept{PAC reannotation}
