% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_gene_p.R
\name{vis_gene_p}
\alias{vis_gene_p}
\title{Sample spatial gene visualization workhorse function}
\usage{
vis_gene_p(
  spe,
  d,
  sampleid = unique(spe$sample_id)[1],
  spatial,
  title,
  viridis = TRUE,
  image_id = "lowres",
  alpha = NA,
  cont_colors = if (viridis) viridisLite::viridis(21) else c("aquamarine4",
    "springgreen", "goldenrod", "red"),
  point_size = 2,
  auto_crop = TRUE,
  na_color = "#CCCCCC40",
  legend_title = ""
)
}
\arguments{
\item{spe}{A
\link[SpatialExperiment:SpatialExperiment]{SpatialExperiment-class}
object. See \code{\link[=fetch_data]{fetch_data()}} for how to download some example objects or
\code{\link[=read10xVisiumWrapper]{read10xVisiumWrapper()}} to read in \code{spaceranger --count} output files and
build your own \code{spe} object.}

\item{d}{A \code{data.frame()} with the sample-level information. This is
typically obtained using \code{cbind(colData(spe), spatialCoords(spe))}.
The \code{data.frame} has to contain
a column with the continuous variable data to plot stored under \code{d$COUNT}.}

\item{sampleid}{A \code{character(1)} specifying which sample to plot from
\code{colData(spe)$sample_id} (formerly \code{colData(spe)$sample_name}).}

\item{spatial}{A \code{logical(1)} indicating whether to include the histology
layer from \code{\link[=geom_spatial]{geom_spatial()}}. If you plan to use
\link[plotly:ggplotly]{ggplotly()} then it's best to set this to \code{FALSE}.}

\item{title}{The title for the plot.}

\item{viridis}{A \code{logical(1)} whether to use the color-blind friendly
palette from \link[viridisLite:viridis]{viridis} or the color palette used
in the paper that was chosen for contrast when visualizing the data on
top of the histology image. One issue is being able to differentiate low
values from NA ones due to the purple-ish histology information that is
dependent on cell density.}

\item{image_id}{A \code{character(1)} with the name of the image ID you want to
use in the background.}

\item{alpha}{A \code{numeric(1)} in the \verb{[0, 1]} range that specifies the
transparency level of the data on the spots.}

\item{cont_colors}{A \code{character()} vector of colors that supersedes the
\code{viridis} argument.}

\item{point_size}{A \code{numeric(1)} specifying the size of the points. Defaults
to \code{1.25}. Some colors look better if you use \code{2} for instance.}

\item{auto_crop}{A \code{logical(1)} indicating whether to automatically crop
the image / plotting area, which is useful if the Visium capture area is
not centered on the image and if the image is not a square.}

\item{na_color}{A \code{character(1)} specifying a color for the NA values.
If you set \code{alpha = NA} then it's best to set \code{na_color} to a color that has
alpha blending already, which will make non-NA values pop up more and the NA
values will show with a lighter color. This behavior is lost when \code{alpha} is
set to a non-\code{NA} value.}

\item{legend_title}{A \code{character(1)} specifying the legend title.}
}
\value{
A \link[ggplot2:ggplot]{ggplot2} object.
}
\description{
This function visualizes the gene expression stored in \code{assays(spe)} or any
continuous variable stored in \code{colData(spe)} for one given sample at the
spot-level using (by default) the histology information on the background.
This is the function that does all the plotting behind \code{\link[=vis_gene]{vis_gene()}}
To visualize clusters (or any discrete variable) use \code{\link[=vis_clus_p]{vis_clus_p()}}.
}
\examples{

if (enough_ram()) {
    ## Obtain the necessary data
    if (!exists("spe")) spe <- fetch_data("spe")

    ## Prepare the data for the plotting function
    spe_sub <- spe[, spe$sample_id == "151673"]
    df <- as.data.frame(cbind(colData(spe_sub), SpatialExperiment::spatialCoords(spe_sub)), optional = TRUE)
    df$COUNT <- df$expr_chrM_ratio

    ## Don't plot the histology information
    p <- vis_gene_p(
        spe = spe_sub,
        d = df,
        sampleid = "151673",
        title = "151673 chrM expr ratio",
        spatial = FALSE
    )
    print(p)

    ## Clean up
    rm(spe_sub)
}
}
\seealso{
Other Spatial gene visualization functions: 
\code{\link{vis_gene}()},
\code{\link{vis_grid_gene}()}
}
\concept{Spatial gene visualization functions}
