% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sce_to_spe.R
\name{sce_to_spe}
\alias{sce_to_spe}
\title{Convert a SCE object to a SPE one}
\usage{
sce_to_spe(sce = fetch_data("sce"), imageData = NULL)
}
\arguments{
\item{sce}{Defaults to the output of
\code{fetch_data(type = 'sce')}. This is a
\linkS4class{SingleCellExperiment}
object with the spot-level Visium data and information required for
visualizing the histology. See \code{\link[=fetch_data]{fetch_data()}} for more details.}

\item{imageData}{A \code{DataFrame()} with image data. Will be used with
\link[SpatialExperiment:SpatialExperiment-methods]{SpatialExperiment::imgData}.
If \code{NULL}, then this will be constructed for you assuming that you are
working with the original data from \code{spatialLIBD::fetch_data("sce")}.}
}
\value{
A a
\link[SpatialExperiment:SpatialExperiment]{SpatialExperiment-class}  object.
}
\description{
This function converts a spot-level
\link[SingleCellExperiment:SingleCellExperiment]{SingleCellExperiment-class}
(SCE) object as generated by \code{fetch_data()} to a
\link[SpatialExperiment:SpatialExperiment]{SpatialExperiment-class} (SPE)
object.
}
\details{
Note that the resulting object is a bit more complex than a regular SPE
because it contains the data from the spatialLIBD project which you might
otherwise have to generate for your own data.
}
\examples{

if (enough_ram()) {
    ## Download the sce data
    sce <- fetch_data("sce")
    ## Transform it to a SpatialExperiment object
    spe <- sce_to_spe(sce)
}
}
\author{
Brenda Pardo, Leonardo Collado-Torres
}
\concept{SpatialExperiment-related functions}
