% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_set_enrichment.R
\name{gene_set_enrichment}
\alias{gene_set_enrichment}
\title{Evaluate the enrichment for a list of gene sets}
\usage{
gene_set_enrichment(
  gene_list,
  fdr_cut = 0.1,
  modeling_results = fetch_data(type = "modeling_results"),
  model_type = names(modeling_results)[1],
  reverse = FALSE
)
}
\arguments{
\item{gene_list}{A named \code{list} object (could be a \code{data.frame}) where each
element of the list is a character vector of Ensembl gene IDs.}

\item{fdr_cut}{A \code{numeric(1)} specifying the FDR cutoff to use for
determining significance among the modeling results genes.}

\item{modeling_results}{Defaults to the output of
\code{fetch_data(type = 'modeling_results')}. This is a list of tables with the
columns \verb{f_stat_*} or \verb{t_stat_*} as well as \verb{p_value_*} and \verb{fdr_*} plus
\code{ensembl}. The column name is used to extract the statistic results, the
p-values, and the FDR adjusted p-values. Then the \code{ensembl} column is used
for matching in some cases. See \code{\link[=fetch_data]{fetch_data()}} for more details. Typically
this is the set of reference statistics used in \code{layer_stat_cor()}.}

\item{model_type}{A named element of the \code{modeling_results} list. By default
that is either \code{enrichment} for the model that tests one human brain layer
against the rest (one group vs the rest), \code{pairwise} which compares two
layers (groups) denoted by \code{layerA-layerB} such that \code{layerA} is greater
than \code{layerB}, and \code{anova} which determines if any layer (group) is different
from the rest adjusting for the mean expression level. The statistics for
\code{enrichment} and \code{pairwise} are t-statistics while the \code{anova} model ones
are F-statistics.}

\item{reverse}{A \code{logical(1)} indicating whether to multiply by \code{-1} the
input statistics and reverse the \code{layerA-layerB} column names (using the \code{-})
into \code{layerB-layerA}.}
}
\value{
A table in long format with the enrichment results using
\code{\link[stats:fisher.test]{stats::fisher.test()}}.
\itemize{
\item \code{OR} odds ratio.
\item \code{Pval} p-value for \code{fisher.test()}.
\item \code{test} group or layer in the \code{modeling_results}.
\item \code{NumSig} Number of genes from the gene set present in \code{modeling_results} &
with \code{fdr < fdr_cut} and \code{t_stat > 0} (unless reverse = TRUE) for \code{test} in
modeling results.
\item \code{SetSize} Number of genes from \code{modeling_results} present in \code{gene_set}.
\item \code{ID} name of gene set.
\item \code{model_type} record of input model type from \verb{modeling results}.
\item \code{fdr_cut} record of input \code{frd_cut}.
}
}
\description{
Using the layer-level (group-level) data, this function evaluates whether
list of gene sets (Ensembl gene IDs) are enriched among the significant
genes (FDR < 0.1 by default) genes for a given model type result. Test the
alternative hypothesis that OR > 1, i.e. that gene set is over-represented in the
set of enriched genes. If you want to check depleted genes, change \code{reverse}
to \code{TRUE}.
}
\details{
Check
https://github.com/LieberInstitute/HumanPilot/blob/master/Analysis/Layer_Guesses/check_clinical_gene_sets.R
to see a full script from where this family of functions is derived from.
}
\examples{

## Read in the SFARI gene sets included in the package
asd_sfari <- utils::read.csv(
    system.file(
        "extdata",
        "SFARI-Gene_genes_01-03-2020release_02-04-2020export.csv",
        package = "spatialLIBD"
    ),
    as.is = TRUE
)

## Format them appropriately
asd_sfari_geneList <- list(
    Gene_SFARI_all = asd_sfari$ensembl.id,
    Gene_SFARI_high = asd_sfari$ensembl.id[asd_sfari$gene.score < 3],
    Gene_SFARI_syndromic = asd_sfari$ensembl.id[asd_sfari$syndromic == 1]
)

## Obtain the necessary data
if (!exists("modeling_results")) {
    modeling_results <- fetch_data(type = "modeling_results")
}

## Compute the gene set enrichment results
asd_sfari_enrichment <- gene_set_enrichment(
    gene_list = asd_sfari_geneList,
    modeling_results = modeling_results,
    model_type = "enrichment"
)

## Explore the results
asd_sfari_enrichment
}
\seealso{
Other Gene set enrichment functions: 
\code{\link{gene_set_enrichment_plot}()}
}
\author{
Andrew E Jaffe, Leonardo Collado-Torres
}
\concept{Gene set enrichment functions}
