% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_sce.R
\name{check_sce}
\alias{check_sce}
\title{Check input sce}
\usage{
check_sce(
  sce,
  variables = c("GraphBased", "ManualAnnotation", "Maynard", "Martinowich",
    paste0("SNN_k50_k", 4:28), "spatialLIBD", "cell_count", "sum_umi", "sum_gene",
    "expr_chrM", "expr_chrM_ratio", "SpatialDE_PCA", "SpatialDE_pool_PCA", "HVG_PCA",
    "pseudobulk_PCA", "markers_PCA", "SpatialDE_UMAP", "SpatialDE_pool_UMAP", "HVG_UMAP",
    "pseudobulk_UMAP", "markers_UMAP", "SpatialDE_PCA_spatial",
    "SpatialDE_pool_PCA_spatial", "HVG_PCA_spatial", "pseudobulk_PCA_spatial",
    "markers_PCA_spatial", "SpatialDE_UMAP_spatial", "SpatialDE_pool_UMAP_spatial", 
    
    "HVG_UMAP_spatial", "pseudobulk_UMAP_spatial", "markers_UMAP_spatial")
)
}
\arguments{
\item{sce}{Defaults to the output of
\code{fetch_data(type = 'sce')}. This is a
\linkS4class{SingleCellExperiment}
object with the spot-level Visium data and information required for
visualizing the histology. See \code{\link[=fetch_data]{fetch_data()}} for more details.}

\item{variables}{A \code{character()} vector of variable names expected to
be present in \code{colData(sce)}.}
}
\value{
The input object if all checks are passed.
}
\description{
This function checks that the \code{sce} object has the appropriate structure.
This is a legacy function and we highly encourage you to use
\link[SpatialExperiment:SpatialExperiment]{SpatialExperiment-class}
objects and check them with \code{check_spe()}.
}
\examples{

if (enough_ram()) {
    ## Obtain the necessary data
    if (!exists("sce_example")) sce_example <- fetch_data("sce_example")

    ## Check the object
    check_sce(sce_example)
}
}
\seealso{
Other Check input functions: 
\code{\link{check_modeling_results}()},
\code{\link{check_sce_layer}()},
\code{\link{check_spe}()}
}
\concept{Check input functions}
