library(here)
library(sessioninfo)
library(tidyverse)

outdir <- "spatialLIBD_files"
pkgname <- "spatialLIBD"

meta <- tibble(
    Title = c("visiumStitched_brain_spe", "visiumStitched_brain_spaceranger", "visiumStitched_brain_Fiji_out"),
    Description = c(
        "SpatialExperiment object at the spot-level for the spatially stitched human brain spatial transcriptomics data (n = 3) from the Visium platform from 10x Genomics generated by the Lieber Institute for Brain Development (LIBD) and available through the spatialLIBD Bioconductor package.",
        "Spaceranger outputs for the spatially stitched human brain (spatial transcriptomics data (n = 3) from the Visium platform from 10x Genomics generated by the Lieber Institute for Brain Development (LIBD) and available through the spatialLIBD Bioconductor package. Can be used with visiumStitched::build_spe() to construct a SpatialExperiment.",
        "Stitched PNG image and XML file from aligning human brain spatial transcriptomics data (n = 3) in Fiji. Data to align was from the Visium platform from 10x Genomics generated by the Lieber Institute for Brain Development (LIBD) and is available through the spatialLIBD Bioconductor package."
    ),
    BiocVersion = "3.19",
    Genome = "GRCh38",
    SourceType = c("GTF", "Zip", "Zip"),
    SourceUrl = "https://bioconductor.org/packages/spatialLIBD",
    SourceVersion = "June 11 2024",
    Species = "Homo sapiens",
    TaxonomyId = 9606,
    Coordinate_1_based = TRUE,
    DataProvider = "LIBD",
    Maintainer = "Leonardo Collado-Torres <lcolladotor@gmail.com>",
    RDataClass = c("SpatialExperiment", "list", "list"),
    DispatchClass = c("Rds", "Zip", "Zip"),
    RDataPath = file.path(
        pkgname,
        outdir,
        c(
            "visiumStitched_brain_spe.rds", "visiumStitched_brain_spaceranger.zip",
            "visiumStitched_brain_fiji_out.zip"
        )
    ),
    Tags = "visiumStitched_brain_spatialLIBD"
)

write_csv(meta, here("inst", "extdata", "metadata_visiumStitched_brain.csv"))

## Check interactively
if (FALSE) {
    AnnotationHubData::makeAnnotationHubMetadata(
        here(),
        fileName = "metadata_visiumStitched_brain.csv"
    )
}

## Reproducibility information
print("Reproducibility information:")
Sys.time()
proc.time()
options(width = 120)
session_info()

# ─ Session info ───────────────────────────────────────────────────────────────────────────────────────────────────────────────────
#  setting  value
#  version  R version 4.4.0 Patched (2024-05-22 r86590)
#  os       Rocky Linux 9.2 (Blue Onyx)
#  system   x86_64, linux-gnu
#  ui       X11
#  language (EN)
#  collate  en_US.UTF-8
#  ctype    en_US.UTF-8
#  tz       US/Eastern
#  date     2024-06-11
#  pandoc   3.1.13 @ /jhpce/shared/community/core/conda_R/4.4/bin/pandoc

# ─ Packages ───────────────────────────────────────────────────────────────────────────────────────────────────────────────────────
#  package              * version     date (UTC) lib source
#  abind                  1.4-5       2016-07-21 [2] CRAN (R 4.4.0)
#  AnnotationDbi          1.66.0      2024-05-01 [2] Bioconductor 3.19 (R 4.4.0)
#  AnnotationForge        1.46.0      2024-04-30 [2] Bioconductor 3.19 (R 4.4.0)
#  AnnotationHub          3.12.0      2024-04-30 [2] Bioconductor 3.19 (R 4.4.0)
#  AnnotationHubData      1.34.0      2024-04-30 [1] Bioconductor 3.19 (R 4.4.0)
#  Biobase                2.64.0      2024-04-30 [2] Bioconductor 3.19 (R 4.4.0)
#  BiocBaseUtils          1.6.0       2024-04-30 [2] Bioconductor 3.19 (R 4.4.0)
#  BiocCheck              1.40.0      2024-04-30 [2] Bioconductor 3.19 (R 4.4.0)
#  BiocFileCache          2.12.0      2024-04-30 [2] Bioconductor 3.19 (R 4.4.0)
#  BiocGenerics           0.50.0      2024-04-30 [2] Bioconductor 3.19 (R 4.4.0)
#  BiocIO                 1.14.0      2024-04-30 [2] Bioconductor 3.19 (R 4.4.0)
#  BiocManager            1.30.23     2024-05-04 [2] CRAN (R 4.4.0)
#  BiocParallel           1.38.0      2024-04-30 [2] Bioconductor 3.19 (R 4.4.0)
#  BiocVersion            3.19.1      2024-04-17 [2] Bioconductor 3.19 (R 4.4.0)
#  biocViews              1.72.0      2024-04-30 [2] Bioconductor 3.19 (R 4.4.0)
#  biomaRt                2.60.0      2024-04-30 [2] Bioconductor 3.19 (R 4.4.0)
#  Biostrings             2.72.0      2024-04-30 [2] Bioconductor 3.19 (R 4.4.0)
#  bit                    4.0.5       2022-11-15 [2] CRAN (R 4.4.0)
#  bit64                  4.0.5       2020-08-30 [2] CRAN (R 4.4.0)
#  bitops                 1.0-7       2021-04-24 [2] CRAN (R 4.4.0)
#  blob                   1.2.4       2023-03-17 [2] CRAN (R 4.4.0)
#  cachem                 1.1.0       2024-05-16 [2] CRAN (R 4.4.0)
#  cli                    3.6.2       2023-12-11 [2] CRAN (R 4.4.0)
#  codetools              0.2-20      2024-03-31 [3] CRAN (R 4.4.0)
#  colorspace             2.1-0       2023-01-23 [2] CRAN (R 4.4.0)
#  crayon                 1.5.2       2022-09-29 [2] CRAN (R 4.4.0)
#  curl                   5.2.1       2024-03-01 [2] CRAN (R 4.4.0)
#  DBI                    1.2.2       2024-02-16 [2] CRAN (R 4.4.0)
#  dbplyr                 2.5.0       2024-03-19 [2] CRAN (R 4.4.0)
#  DelayedArray           0.30.1      2024-05-07 [2] Bioconductor 3.19 (R 4.4.0)
#  digest                 0.6.35      2024-03-11 [2] CRAN (R 4.4.0)
#  dplyr                * 1.1.4       2023-11-17 [2] CRAN (R 4.4.0)
#  fansi                  1.0.6       2023-12-08 [2] CRAN (R 4.4.0)
#  fastmap                1.2.0       2024-05-15 [2] CRAN (R 4.4.0)
#  filelock               1.0.3       2023-12-11 [2] CRAN (R 4.4.0)
#  forcats              * 1.0.0       2023-01-29 [2] CRAN (R 4.4.0)
#  formatR                1.14        2023-01-17 [2] CRAN (R 4.4.0)
#  futile.logger        * 1.4.3       2016-07-10 [2] CRAN (R 4.4.0)
#  futile.options         1.0.1       2018-04-20 [2] CRAN (R 4.4.0)
#  generics               0.1.3       2022-07-05 [2] CRAN (R 4.4.0)
#  GenomeInfoDb           1.40.0      2024-04-30 [2] Bioconductor 3.19 (R 4.4.0)
#  GenomeInfoDbData       1.2.12      2024-05-23 [2] Bioconductor
#  GenomicAlignments      1.40.0      2024-04-30 [2] Bioconductor 3.19 (R 4.4.0)
#  GenomicFeatures        1.56.0      2024-04-30 [2] Bioconductor 3.19 (R 4.4.0)
#  GenomicRanges          1.56.0      2024-05-01 [2] Bioconductor 3.19 (R 4.4.0)
#  ggplot2              * 3.5.1       2024-04-23 [2] CRAN (R 4.4.0)
#  glue                   1.7.0       2024-01-09 [2] CRAN (R 4.4.0)
#  graph                  1.82.0      2024-04-30 [2] Bioconductor 3.19 (R 4.4.0)
#  gtable                 0.3.5       2024-04-22 [2] CRAN (R 4.4.0)
#  here                 * 1.0.1       2020-12-13 [2] CRAN (R 4.4.0)
#  hms                    1.1.3       2023-03-21 [2] CRAN (R 4.4.0)
#  httr                   1.4.7       2023-08-15 [2] CRAN (R 4.4.0)
#  httr2                  1.0.1       2024-04-01 [2] CRAN (R 4.4.0)
#  IRanges                2.38.0      2024-04-30 [2] Bioconductor 3.19 (R 4.4.0)
#  jsonlite               1.8.8       2023-12-04 [2] CRAN (R 4.4.0)
#  KEGGREST               1.44.0      2024-04-30 [2] Bioconductor 3.19 (R 4.4.0)
#  knitr                  1.46        2024-04-06 [2] CRAN (R 4.4.0)
#  lambda.r               1.2.4       2019-09-18 [2] CRAN (R 4.4.0)
#  lattice                0.22-6      2024-03-20 [3] CRAN (R 4.4.0)
#  lifecycle              1.0.4       2023-11-07 [2] CRAN (R 4.4.0)
#  lubridate            * 1.9.3       2023-09-27 [2] CRAN (R 4.4.0)
#  magrittr               2.0.3       2022-03-30 [2] CRAN (R 4.4.0)
#  Matrix                 1.7-0       2024-04-26 [3] CRAN (R 4.4.0)
#  MatrixGenerics         1.16.0      2024-04-30 [2] Bioconductor 3.19 (R 4.4.0)
#  matrixStats            1.3.0       2024-04-11 [2] CRAN (R 4.4.0)
#  memoise                2.0.1       2021-11-26 [2] CRAN (R 4.4.0)
#  munsell                0.5.1       2024-04-01 [2] CRAN (R 4.4.0)
#  OrganismDbi            1.46.0      2024-04-30 [2] Bioconductor 3.19 (R 4.4.0)
#  pillar                 1.9.0       2023-03-22 [2] CRAN (R 4.4.0)
#  pkgconfig              2.0.3       2019-09-22 [2] CRAN (R 4.4.0)
#  png                    0.1-8       2022-11-29 [2] CRAN (R 4.4.0)
#  prettyunits            1.2.0       2023-09-24 [2] CRAN (R 4.4.0)
#  progress               1.2.3       2023-12-06 [2] CRAN (R 4.4.0)
#  purrr                * 1.0.2       2023-08-10 [2] CRAN (R 4.4.0)
#  R6                     2.5.1       2021-08-19 [2] CRAN (R 4.4.0)
#  rappdirs               0.3.3       2021-01-31 [2] CRAN (R 4.4.0)
#  RBGL                   1.80.0      2024-04-30 [2] Bioconductor 3.19 (R 4.4.0)
#  RCurl                  1.98-1.14   2024-01-09 [2] CRAN (R 4.4.0)
#  readr                * 2.1.5       2024-01-10 [2] CRAN (R 4.4.0)
#  restfulr               0.0.15      2022-06-16 [2] CRAN (R 4.4.0)
#  rjson                  0.2.21      2022-01-09 [2] CRAN (R 4.4.0)
#  rlang                  1.1.3       2024-01-10 [2] CRAN (R 4.4.0)
#  rprojroot              2.0.4       2023-11-05 [2] CRAN (R 4.4.0)
#  Rsamtools              2.20.0      2024-04-30 [2] Bioconductor 3.19 (R 4.4.0)
#  RSQLite                2.3.6       2024-03-31 [2] CRAN (R 4.4.0)
#  rtracklayer            1.64.0      2024-04-30 [2] Bioconductor 3.19 (R 4.4.0)
#  RUnit                  0.4.33      2024-02-22 [2] CRAN (R 4.4.0)
#  S4Arrays               1.4.1       2024-05-20 [2] Bioconductor 3.19 (R 4.4.0)
#  S4Vectors              0.42.0      2024-04-30 [2] Bioconductor 3.19 (R 4.4.0)
#  scales                 1.3.0       2023-11-28 [2] CRAN (R 4.4.0)
#  sessioninfo          * 1.2.2       2021-12-06 [2] CRAN (R 4.4.0)
#  SparseArray            1.4.5       2024-05-20 [2] Bioconductor 3.19 (R 4.4.0)
#  stringdist             0.9.12      2023-11-28 [2] CRAN (R 4.4.0)
#  stringi                1.8.4       2024-05-06 [2] CRAN (R 4.4.0)
#  stringr              * 1.5.1       2023-11-14 [2] CRAN (R 4.4.0)
#  SummarizedExperiment   1.34.0      2024-05-01 [2] Bioconductor 3.19 (R 4.4.0)
#  tibble               * 3.2.1       2023-03-20 [2] CRAN (R 4.4.0)
#  tidyr                * 1.3.1       2024-01-24 [2] CRAN (R 4.4.0)
#  tidyselect             1.2.1       2024-03-11 [2] CRAN (R 4.4.0)
#  tidyverse            * 2.0.0       2023-02-22 [2] CRAN (R 4.4.0)
#  timechange             0.3.0       2024-01-18 [2] CRAN (R 4.4.0)
#  txdbmaker              1.0.0       2024-04-30 [2] Bioconductor 3.19 (R 4.4.0)
#  tzdb                   0.4.0       2023-05-12 [2] CRAN (R 4.4.0)
#  UCSC.utils             1.0.0       2024-04-30 [2] Bioconductor 3.19 (R 4.4.0)
#  utf8                   1.2.4       2023-10-22 [2] CRAN (R 4.4.0)
#  vctrs                  0.6.5       2023-12-01 [2] CRAN (R 4.4.0)
#  vroom                  1.6.5       2023-12-05 [2] CRAN (R 4.4.0)
#  withr                  3.0.0       2024-01-16 [2] CRAN (R 4.4.0)
#  xfun                   0.44        2024-05-15 [2] CRAN (R 4.4.0)
#  XML                    3.99-0.16.1 2024-01-22 [2] CRAN (R 4.4.0)
#  xml2                   1.3.6       2023-12-04 [2] CRAN (R 4.4.0)
#  XVector                0.44.0      2024-04-30 [2] Bioconductor 3.19 (R 4.4.0)
#  yaml                   2.3.8       2023-12-11 [2] CRAN (R 4.4.0)
#  zlibbioc               1.50.0      2024-04-30 [2] Bioconductor 3.19 (R 4.4.0)

#  [1] /users/neagles/R/4.4
#  [2] /jhpce/shared/community/core/conda_R/4.4/R/lib64/R/site-library
#  [3] /jhpce/shared/community/core/conda_R/4.4/R/lib64/R/library

# ──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────
