% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combineNormRes.R
\name{combineNormRes}
\alias{combineNormRes}
\title{Combine Normalized Data from Different Chip Types}
\usage{
combineNormRes(chiptype_dir, norm_method)
}
\arguments{
\item{chiptype_dir}{character vector containing paths to chiptype directories}

\item{norm_method}{normalization method, one of "MAS5" or "rma".}
}
\value{
Object of class \code{data.frame} containing normalization values
}
\description{
Function assembles normalization results from different chip types
into a single data frame. Note, this is possible since the three chip types
used by the CMap2 project contain nearly identical probe set ids. Typically,
the input for this step is generated by the upstream \code{normalizeCel} and
\code{combineResults} functions. For more context, please consult the vignette
of this package.
}
\examples{
# chiptype_dir <- unique(readRDS("./data/chiptype.rds"))
combineNormRes(chiptype_dir, norm_method="not run")
}
