% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gregoire2023_mixCTRL.R
\docType{data}
\name{gregoire2023_mixCTRL}
\alias{gregoire2023_mixCTRL}
\title{Grégoire et al. 2023 - mixCTRL (arXiv): benchmark using
monocytes/macrophages}
\format{
A \link{QFeatures} object with 119 assays, each assay being a
\link{SingleCellExperiment} object:
\itemize{
\item Assays 1-42: PSM data acquired with a TMT-16plex protocol, hence
those assays contain 16 columns. Columns hold quantitative
information from single-cell channels, carrier channels,
blank (negative control) channels and unused channels.
\item Assays 43-84: peptide data resulting from the PSM to peptide
aggregation of the 42 PSM assays.
\item Assays 85-91: peptide data for each of the 7 acquisition
batches. Peptide data were joined based on their respective
acquisition batches.
\item Assays 92-98: normalised peptide data.
\item Assays 99-105: normalised and log-transformed peptide data.
\item Assays 106-112: protein data for each of the 7 acquisition
batches. Normalised and log-transformed peptide data were
agreggated to protein.
\item Assays 113-119: Batch corrected protein data. Normalised and
log-transformed protein data were batch corrected to remove
technical variability induced by runs and channels.
}

All the data has been filtered to keep high quality features and
samples.

The \code{colData(gregoire2023_mixCTRL())} contains cell type annotation and
batch annotation that are common to all assays. The description of
the \code{rowData} fields for the PSM data can be found in the
\href{https://sage-docs.vercel.app/docs/results/search}{\code{sage} documentation}.
}
\source{
The data were downloaded from the \href{https://zenodo.org/records/8417228}{Zenodo repository}.  The raw data and
the quantification data can also be found in the ProteomeXchange
Consortium via the \href{https://www.ebi.ac.uk/pride/archive/projects/PXD046211}{PRIDE partner repository},
project \code{PXD046211}.
}
\usage{
gregoire2023_mixCTRL
}
\description{
Single cell proteomics data acquired using the SCoPE2 protocol.
The dataset contains two monocytes cell lines (THP1 and U937) as
well as controled mixtures of both and macrophage-like cells
produced upon PMA treatment. It contains quantitative information
at PSM, peptide and protein levels. Data was acquired using Lumos
Orbitrap (mainly) and timsTOF SCP mass spectrometers.
}
\section{Acquisition protocol}{


The data were acquired using the following setup. More information
can be found in the source article (see \emph{References}).
\itemize{
\item \strong{Cell isolation}: BD FACSAria III cell sorting.
\item \strong{Sample preparation} performed using the SCoPE2 protocol: mPOP
cell lysis + trypsin digestion + TMT-16plex labeling and
pooling.
\item \strong{Separation}: online nLC (Ultimate 3000 LC System or Vanquish
Neo UHPLC System) with a BioZen Peptide Polar C18 250 x 0.0075mm
column.
\item \strong{Mass spectrometry}:  Orbitrap Fusion Lumos Tribrid (MS1
resolution = 70,000; MS2 accumulation time = 120ms; MS2
resolution = 70,000) and timsTOF SCP.
\item \strong{Data preprocessing}: Sage.
}
}

\section{Data collection}{


The PSM data were collected from a Zenodo archive (see \code{Source}
section). The folder contains the following files of interest:
\itemize{
\item \code{results.sage.cbio.tsv}: the sage identification output file for
batches acquired on the Lumos MS.
\item \code{results.sage.giga.tsv}: the sage identification output file for
batches acquired on the timsTOF SCP MS.
\item \code{quant.cbio.tsv}: the sage quantification output file for
batches acquired on the Lumos MS.
\item \code{quant.giga.tsv}: the sage quantification output file for
batches acquired on the timsTOF SCP MS.
\item \code{sampleAnnotation_batch.csv}: sample annotation for each
acquisition batch. There are in total 8 different annotation
files.
}

We combined the sample annotations in a single table. We also
combined \code{cbio} and \code{giga} tables together and merged resulting
identification and quantification tables. Both annotation and
features tables are then combined in a single \link{QFeatures} object
using the \code{\link[scp:readSCP]{scp::readSCP()}} function.

The \link{QFeatures} object was processed as described in the author's
manuscript (see \code{source}). Note that the imputed assays were used
in the paper for illustrative purposes only and have not been
reproduced here.
}

\examples{
\donttest{
gregoire2023_mixCTRL()
}

}
\references{
Samuel Grégoire, Christophe Vanderaa, Sébastien Pyr dit Ruys,
Gabriel Mazzucchelli, Christopher Kune, Didier Vertommen and
Laurent Gatto. 2023. \emph{Standardised workflow for mass spectrometry-
based single-cell proteomics data processing and analysis using
the scp package.}
arXiv. DOI:\href{https://doi.org/10.48550/arXiv.2310.13598}{10.48550/arXiv.2310.13598}
}
\keyword{datasets}
