% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HermannSpermatogenesisData.R
\name{HermannSpermatogenesisData}
\alias{HermannSpermatogenesisData}
\title{Obtain the Hermann spermatogenesis data}
\usage{
HermannSpermatogenesisData(strip = FALSE, location = TRUE, legacy = FALSE)
}
\arguments{
\item{strip}{Logical scalar indicating whether to strip the \code{.X} notation from the row names.}

\item{location}{Logical scalar indicating whether genomic coordinates should be returned.
Only used if \code{strip=TRUE}.}

\item{legacy}{Logical scalar indicating whether to pull data from ExperimentHub.
By default, we use data from the gypsum backend.}
}
\value{
A \link[SingleCellExperiment]{SingleCellExperiment} object with two matrices, containing spliced and unspliced counts, respectively.
}
\description{
Obtain the mouse spermatogenesis single-cell RNA-seq data from Hermann et al. (2018).
}
\details{
Column metadata contains cell types provided by the data generators
at \url{https://data.mendeley.com/datasets/kxd5f8vpt4/1#file-fe79c10b-c42e-472e-9c7e-9a9873d9b3d8}.

All data are downloaded from ExperimentHub and cached for local re-use.
Specific resources can be retrieved by searching for \code{scRNAseq/hermann-spermatogenesis}.
}
\examples{
sce <- HermannSpermatogenesisData()

}
\references{
Hermann B.P. et al. (2018).
The Mammalian Spermatogenesis Single-Cell Transcriptome, from Spermatogonial Stem Cells to Spermatids. 
\emph{Cell Rep.} 25(6), 1650-1667.e8.
}
\author{
Charlotte Soneson
}
