\name{andy2011}
\alias{andy2011}
\alias{andy2011goCC}
\alias{andy2011hpa}
\alias{HEK293T2011}
\alias{HEK293T2011hpa}
\alias{HEK293T2011goCC}


\docType{data}

\title{
  LOPIT experiment on Human Embryonic Kidney fibroblast HEK293T cells
  from Breckels et al. (2013)
}

\description{
  This is a LOPIT dataset from a standard LOPIT experimental design on Human
  Embryonic Kidney (HEK293T) fibroblast cells. See below for more
  details. 

  Note: this data was originally called \code{andy2011}. It is still
  available under that name but might be deprecated in the future and
  hence it is advised to use \code{HEK293T2011}.
  
}

\usage{
data(HEK293T2011)
data(HEK293T2011hpa)
data(HEK293T2011goCC)
}

\format{
  The data is an instance of class \code{MSnSet} from package \code{MSnbase}.
}

\details{
  This is a LOPIT experiment. Normalised intensities for 1371 proteins
  for eight iTRAQ 8-plex labelled fractions.
  This dataset was used in testing the phenotype discovery algorithm from 
  Breckels et al., \emph{The Effect of Organelle Discovery upon Sub-Cellular 
  Protein Localisation}, J Proteomics, 2013, 88:129-40, see \code{phenoDisco}. 
  New phenotype clusters identified from algorithm application are available as 
  \code{pd.2013} feature meta-data and the markers used as input for the analysis 
  are available as \code{markers} feature meta-data.

  The \code{HEK293T2011goCC} instance contains binary assay data. Its
  columns represent GO CC terms that have been observed for the object's
  features. A 1 indicates that a GO term has been associated to a given
  feature (protein); a 0 means not such association was found in the GO
  ontology.
  
  The \code{HEK293T2011hpa} instance contains binary assay data. Its
  columns represent subcellular locations that have been observed from
  microscopy images from the Human Protein Atlas, for each protein. A 1
  indicates that a subcellular term has been associated to a given
  feature (protein); a 0 means not such association was found. This
  matrix of terms was generated from version 13, released on 11/06/2014
  of the Human Protein Atlas.
  
}

\source{
  The data was generated by A. Christoforou at the Cambridge Centre for 
  Proteomics. 

  \url{http://www.bio.cam.ac.uk/proteomics/}. 
}

\references{
  Breckels LM, Gatto L, Christoforou A, Groen AJ, Lilley KS and Trotter
  MWB. \emph{The Effect of Organelle Discovery upon Sub-Cellular Protein
  Localisation.} J Proteomics. 2013 Aug 2;88:129-40. doi:
  10.1016/j.jprot.2013.02.019. Epub 2013 Mar 21. PubMed PMID: 23523639
}

\examples{
data(HEK293T2011)
HEK293T2011
pData(HEK293T2011)
head(exprs(HEK293T2011))
## Organelle marker proteins
table(fData(HEK293T2011)$markers)
## PhenoDisco assignment results
table(fData(HEK293T2011)$pd.2013)

data(HEK293T2011goCC)
dim(HEK293T2011goCC)
head(featureNames(HEK293T2011goCC))
exprs(HEK293T2011goCC)[1:10, 1:5]
}

\keyword{datasets}
