% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/octad.db.R
\docType{package}
\name{octad.db}
\alias{octad.db}
\title{Open Cancer TherApeutic Discovery (OCTAD) database package}
\description{
This is a support package for the main package \code{octad} which can be obtained \href{https://bioconductor.org/packages/octad}{here}
}
\details{
Package includes all required data for drug repurposing OCTAD pipeline.
Initialization of the pipeline starts with listing all available samples:

\code{phenoDF=.eh[["EH7274"]]} #load data.frame with samples included in the OCTAD database.
\code{head(phenoDF)} #list all data included within the package

Besides, the package includes examples of the output from diffExp and runsRGES functions from the octad package along with desctiption of the data:
\code{res=octad.db::res_example} #load example res from octad.db
\code{?res_example}
\code{sRGES=octad.db::sRGES_example} #load example sRGES from octad.db
\code{?sRGES_example}

\code{CCLE.log2.read.count.matrix} log2-transformed matrix containing expression of 56,318 genes in 1,019 cell lines provided in CCLE database
\code{CCLE.overlaps}  log2-transformed matrix containing expression of 56,318 genes in 51 cell lines present in both LINCS and CCLE databases
\code{CCLE.sample.meta} data.frame containing cell lines name and tissue of origin from CCLE database
\code{CTRPv2.sensprof} Cancer Therapeutics Response Portal (CTRP) data.frame containing AUC and IC50 for every drug-cell line pair
\code{EncoderDF} a data.frame (64 features by 19127 samples) computed from autoEncoder for every sample in the OCTAD database
\code{cmpd_sets_ChemCluster} list of compounds and their clusters based on chemical structures
\code{cmpd_sets_mesh} list of compounds and their associations with 662 pharmacological MeSH Terms provided in PubChem
\code{fda_drugs} data.frame of FDA approved drugs containing name, target and clinical phase
\code{lincs_sig_info} data.frame for LINCS signatures including experiment id, cell line used in the experiment, purturbagen name, purturbagen type, dose and time
\code{lincs_signatures} Differential expression of 978 genes in 416,560 experiments
\code{merged_gene_info} data.frame with the annotation of 75,078 genes which could be used for identifier mapping
\code{octad.LINCS.counts} expression matrix of 965 genes and 19127 samples in OCTAD database (965 genes were profiled in LINCS)
\code{phenoDF} data.frame with samples from the OCTAD database including tissue of origin, sample type (tumor-derived or healthy-derived), cancer, orginal source (e.g. TCGA), mutation and stage data if available
\code{random_gsea_score} precomputed permutated gsea scores for chembl, mesh and ChemCluster databases that are used for drug enrichment analysis
\code{tsne} 2 dimension tSNE for every sample in the OCTAD database along with sample.id, cancer type and source of the initial data
\code{octad.counts.and.tpm.h5} expression (TPM and raw counts) matrix of 60,498 genes and 19,127 samples

The code can be viewed at the GitHub repository,
which also lists the contributor code of conduct:

\url{https://bioconductor.org/packages/octad} or \url{https://github.com/Bin-Chen-Lab/octad} for the pipeline package
}
\references{
Zeng, B., Glicksberg, B.S., Newbury, P., Chekalin, E., Xing, J., Liu, K., Wen, A., Chow, C. and Chen, B., 2021. OCTAD: an open workspace for virtually screening therapeutics targeting precise cancer patient groups using gene expression features. Nature protocols, 16(2), pp.728-753.
\url{https://www.nature.com/articles/s41596-020-00430-z}
}
