% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_data.R
\name{generate_response_data}
\alias{generate_response_data}
\title{Generate response data}
\usage{
generate_response_data(df_layout, noise_level = 0.1)
}
\arguments{
\item{df_layout}{data.table that should contains the cell line,
drug, concentration, and replicate columns along with the annotations that needs to be propagated}

\item{noise_level}{numeric scalar with the level of noise added to the data}
}
\value{
data.table with response data
}
\description{
Generate response data
}
\examples{

cell_lines <- create_synthetic_cell_lines()
drugs <- create_synthetic_drugs()
df_layout <- prepareData(cell_lines[seq_len(2), ], drugs[seq_len(4), ])
generate_response_data(df_layout)


}
\keyword{generate_results}
