% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetchReference.R
\name{fetchReference}
\alias{fetchReference}
\alias{fetchMetadata}
\title{Fetch a reference dataset}
\usage{
fetchReference(
  name,
  version,
  path = NA,
  package = "celldex",
  cache = cacheDirectory(),
  overwrite = FALSE,
  realize.assays = FALSE,
  ...
)

fetchMetadata(
  name,
  version,
  path = NA,
  package = "celldex",
  cache = cacheDirectory(),
  overwrite = FALSE
)
}
\arguments{
\item{name}{String containing the name of the reference dataset.}

\item{version}{String containing the version of the dataset.}

\item{path}{String containing the path to a subdataset, if \code{name} contains multiple reference datasets.
Defaults to \code{NA} if no subdatasets are present.}

\item{package}{String containing the name of the package.}

\item{cache, overwrite}{Arguments to pass to \code{\link[gypsum]{saveVersion}} or \code{\link[gypsum]{saveFile}}.}

\item{realize.assays}{Logical scalar indicating whether to realize assays into memory.
Dense and sparse \linkS4class{ReloadedArray} objects are converted into ordinary arrays and \linkS4class{dgCMatrix} objects, respectively.}

\item{...}{Further arguments to pass to \code{\link{readObject}}.}
}
\value{
\code{fetchReference} returns the dataset as a \linkS4class{SummarizedExperiment}.
This is guaranteed to have a \code{"logcounts"} assay with log-normalized expression values,
along with at least one character vector of labels in the column data.

\code{fetchMetadata} returns a named list of metadata for the specified dataset.
}
\description{
Fetch a reference dataset (or its metadata) from the gypsum backend.
}
\examples{
fetchReference("immgen", "2024-02-26")
str(fetchMetadata("immgen", "2024-02-26"))

}
\seealso{
\url{https://github.com/ArtifactDB/bioconductor-metadata-index}, on the expected schema for the metadata.

\code{\link{saveReference}} and \code{\link{uploadDirectory}}, to save and upload a dataset.

\code{\link{listReferences}} and \code{\link{listVersions}}, to get possible values for \code{name} and \code{version}.
}
\author{
Aaron Lun
}
