% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TENxVisiumData.R
\name{TENxVisiumData}
\alias{TENxVisiumData}
\alias{HumanBreastCancerIDC}
\alias{HumanBreastCancerILC}
\alias{HumanCerebellum}
\alias{HumanColorectalCancer}
\alias{HumanGlioblastoma}
\alias{HumanHeart}
\alias{HumanLymphNode}
\alias{HumanOvarianCancer}
\alias{HumanSpinalCord}
\alias{MouseBrainCoronal}
\alias{MouseBrainSagittalPosterior}
\alias{MouseBrainSagittalAnterior}
\alias{MouseKidneyCoronal}
\title{TENxVisiumData}
\value{
a \code{\linkS4class{SpatialExperiment}}
with rows corresponding to samples (spots) 
and columns to features (transcripts).
If, in addition to whole transcriptome analysis, 
the specified dataset contains measurements 
from targeted panel analysis/es, 
these will be stored as \code{altExps}.
}
\description{
Collection of Visium spatial gene expression datasets by 10X Genomics, 
formatted into objects of class SpatialExperiment. 
Data cover various organisms and tissues, and include: 
single- and multi-section experiments, as well as single sections 
subjected to both whole transcriptome and targeted panel analysis. 
Datasets may be used for testing of and as examples in packages, 
for tutorials and workflow demonstrations, or similar purposes.
}
\details{
The following Visium Spatial Transcriptomics 
datasets by 10X Genomics are currently available 
(see the package vignette for links to details):
\itemize{
\item{HumanBreastCancerIDC}
\item{HumanBreastCancerILC}
\item{HumanCerebellum}
\item{HumanColorectalCancer}
\item{HumanGlioblastoma}
\item{HumanHeart}
\item{HumanLymphNode}
\item{HumanOvarianCancer}
\item{HumanSpinalCord}
\item{MouseBrainCoronal}
\item{MouseBrainSagittalPosterior}
\item{MouseBrainSagittalAnterior}
\item{MouseKidneyCoronal}
}
}
\examples{
# initialize hub instance
eh <- ExperimentHub()

# query for TENxVisium datasets
(q <- query(eh, "TENxVisium"))

# retrieve dataset of interest
pat <- "HumanCerebellum$"
idx <- grep(pat, q$title)
id <- q$ah_id[idx]
(spe <- eh[[id]])

# access targeted panel
altExpNames(spe)
altExp(spe, "TargetedNeuroscience")

}
\author{
Helena L. Crowell
}
