\name{STexampleData}
\docType{data}
\alias{STexampleData}
\alias{STexampleData-package}
\alias{Visium_humanDLPFC}
\alias{Visium_mouseCoronal}
\alias{seqFISH_mouseEmbryo}
\alias{ST_mouseOB}
\alias{SlideSeqV2_mouseHPC}
\alias{Janesick_breastCancer_Chromium}
\alias{Janesick_breastCancer_Visium}
\alias{Janesick_breastCancer_Xenium_rep1}
\alias{Janesick_breastCancer_Xenium_rep2}
\alias{CosMx_lungCancer}
\alias{MERSCOPE_ovarianCancer}
\alias{STARmapPLUS_mouseBrain}
\title{
Collection of spatial transcriptomics datasets in SpatialExperiment 
Bioconductor format
}
\description{
Collection of spatial transcriptomics datasets in SpatialExperiment 
Bioconductor format, for use in examples, demonstrations, and tutorials. The 
datasets are from several different technological platforms and have been 
sourced from various publicly available sources. Several datasets include 
images and/or reference annotation labels.
}
\details{
The \code{STexampleData} package contains a collection of spatial 
transcriptomics datasets, which have been formatted into the 
\code{SpatialExperiment} Bioconductor class, for use in examples, 
demonstrations, and tutorials.

The datasets are from several different technological platforms and have been 
sourced from various publicly available sources. Several datasets include 
images and/or reference annotation labels.

Additional examples and documentation are provided in the package vignette.

\emph{Datasets}

The \code{STexampleData} package contains the following datasets:

\itemize{
\item Visium_humanDLPFC (10x Genomics Visium): A single sample (sample 151673) 
of human brain dorsolateral prefrontal cortex (DLPFC) in the human brain, 
measured using the 10x Genomics Visium platform. This is a subset of the full 
dataset containing 12 samples from 3 neurotypical donors, published by 
Maynard and Collado-Torres et al. (2021). The full dataset is available from 
the \code{spatialLIBD} Bioconductor package.

\item Visium_mouseCoronal (10x Genomics Visium): A single coronal section from 
the mouse brain, spanning one hemisphere. This dataset was previously released 
by 10x Genomics on their website.

\item seqFISH_mouseEmbryo (seqFISH): A subset of cells (embryo 1, z-slice 2) 
from a previously published dataset investigating mouse embryogenesis by 
Lohoff and Ghazanfar et al. (2022), generated using the seqFISH platform. The 
full dataset is available from the original publication.

\item ST_mouseOB (Spatial Transcriptomics): A single sample from the mouse 
brain olfactory bulb (OB), measured with the Spatial Transcriptomics platform 
(Stahl et al. 2016). This dataset contains annotations for five cell layers 
from the original authors.

\item SlideSeqV2_mouseHPC (Slide-seqV2): A single sample of mouse brain from 
the hippocampus (HPC) and surrounding regions, measured with the Slide-seqV2 
platform (Stickels et al. 2021). This dataset contains cell type annotations 
generated by Cable et al. (2022).

\item Janesick_breastCancer_Chromium (10x Genomics Chromium): 10x Genomics 
Chromium single-cell RNA sequencing data from human breast cancer dataset by 
Janesick et al. (2023). High resolution mapping of the breast cancer tumor 
microenvironment using integrated single-cell, spatial, and in situ analysis of 
FFPE tissue. Contains annotations for cell type from the original authors.

\item Janesick_breastCancer_Visium (10x Genomics Visium): 10x Genomics Visium 
spatial transcriptomics data from human breast cancer dataset by Janesick et 
al. (2023). High resolution mapping of the breast cancer tumor microenvironment 
using integrated single-cell, spatial, and in situ analysis of FFPE tissue.

\item Janesick_breastCancer_Xenium_rep1 (10x Genomics Xenium): 10x Genomics 
Xenium in situ spatial data (sample 1, replicate 1) from human breast cancer 
dataset by Janesick et al. (2023). High resolution mapping of the breast cancer 
tumor microenvironment using integrated single-cell, spatial, and in situ 
analysis of FFPE tissue.

\item Janesick_breastCancer_Xenium_rep2 (10x Genomics Xenium): 10x Genomics 
Xenium in situ spatial data (sample 1, replicate 2) from human breast cancer 
dataset by Janesick et al. (2023). High resolution mapping of the breast cancer 
tumor microenvironment using integrated single-cell, spatial, and in situ 
analysis of FFPE tissue.

\item CosMx_lungCancer (NanoString CosMx): NanoString CosMx human non-small 
cell lung cancer (NSCLC) dataset. Contains data from one sample (patient 9, 
slice 1). This dataset was previously released by NanoString on their website.

\item MERSCOPE_ovarianCancer (Vizgen MERSCOPE): Vizgen MERSCOPE human ovarian 
cancer dataset. Contains data from one sample (patient 2, sample 1). This 
dataset was previously released by Vizgen on their website.

\item STARmapPLUS_mouseBrain (STARmap PLUS): STARmap PLUS mouse brain data by 
Shi et al. (2023). Contains data from one sample (well 05), including 
annotations for cell type and tissue regions from the original authors.
}
}
\examples{
# load using dataset name
spe <- Visium_humanDLPFC()
spe
}
