% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VizgenOutput.R
\name{VizgenOutput}
\alias{VizgenOutput}
\title{Vizgen MERFISH output from human brain cancer}
\usage{
VizgenOutput(
  dataset = datasets,
  file_path = ".",
  force = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{dataset}{Which dataset to use, can be "hdf5" where cell segmentations
are stored in hdf5 files or "cellpose" where cell segmentations are stored in
a parquet file.}

\item{file_path}{Path to save downloaded files for the \code{*Output}
functions which don't return an SFE object.}

\item{force}{Logical, whether to force redownload if the files are already
present. Defaults to \code{FALSE}.}

\item{verbose}{Whether to display progress of download.}
}
\value{
Path to the tarball containing the output directory.
}
\description{
This dataset is unpublished, and is a small subset of the original dataset.
When downloaded, the files are in the output format of Vizgen, not an SFE
object. The purpose of this dataset is to demonstrate and test
\code{readVizgen} in SFE.
}
