% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\docType{data}
\name{hg19}
\alias{hg19}
\title{HG19 - Annotation tables}
\format{\code{list} of four elements - \code{"regions"}, \code{"sites"}, \code{"controls"} and \code{"mappings"}.
        These elements are described below.
        \describe{
          \item{\code{"regions"}}{\code{list} of \code{NULL}s; the names of the elements correspond to the built-in
               region annotation tables. Once the default annotations are loaded, the attribute \code{"builtin"} is
               a \code{logical} vector storing, for each region annotation, whether it is the default (built-in) or
               custom.}
          \item{\code{"sites"}}{\code{list} of \code{NULL}s; the names of the elements correspond to the site and
               probe annotation tables.}
          \item{\code{"controls"}}{\code{list} of \code{NULL}s; the names of the elements correspond to the control
               probe annotation tables. The attribute \code{"sites"} is a \code{character} vector pointing to the
               site annotation that encompasses the respective control probes.}
          \item{\code{"mappings"}}{\code{list} of \code{NULL}s; the names of the elements correspond to the built-in
               region annotation tables.}
        }}
\description{
Scaffold of annotation tables for HG19. This structure is automatically loaded upon initialization of the annotation,
that is, by the first valid call to any of the following functions: \code{\link[RnBeads]{rnb.get.assemblies}},
\code{\link[RnBeads]{rnb.get.chromosomes}}, \code{\link[RnBeads]{rnb.get.annotation}}, \code{\link[RnBeads]{rnb.set.annotation}},
\code{\link[RnBeads]{rnb.get.mapping}}, \code{\link[RnBeads]{rnb.annotation.size}}. Adding an annotation amounts to attaching its
table(s) and mapping structures to this scaffold.
}
\author{
Yassen Assenov
}
\keyword{datasets}
