% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OnassisJavaLibs.R
\docType{package}
\name{OnassisJavaLibs}
\alias{OnassisJavaLibs}
\alias{OnassisJavaLibs-package}
\alias{OnassisJavaLibs-package}
\title{OnASSiSJavaLibs libraries for natural language processing and semantic similarity computation}
\description{
OnassisJavaLibs
}
\details{
Is a data package containing two compiled libraries in jar format and their source code used to
* create a conceptmapper pipeline aimed at finding concepts belonging to OBO ontologies in (OBO, OWL or RDF format) any type of text
* compute different semantic similarity measures between two concepts or two sets of concepts

The methods for the conceptmapper pipeline have been developed and published by the Reagents of the University of Colorado under BSD 3-clause license. In order to have a jar file including all the needed dependencies, the source code avaiable in the GitHub repository https://github.com/UCDenver-ccp/ccp-nlp, version 3.3.2 has been compiled using maven with the following goals:
/code{ mvn clean compile assembly:single  -Dlog4j.configuration=log4j2.properties}
The methods for computing the semantic similarities instead have been developed and published by the the Ecole des mines d'Alès under the GPL-compatible CeCILL licence. In this case the source code available in the GitHub repository https://github.com/sharispe/slib, version 0.9.5, has been downloaded and modified in some parts to load OBO ontologies without generating an exception if a namespace is not provided. In particular, in the new version of the library the following files have been modified:
<ul>
<li> GraphLoader_OBO_1_2.java to add the namespace when the OBO file is loaded in a graph </li>
<li> SMConstants.java to add more short flags to the SIM_PAIRWISE_SHORT_FLAGS </li>
<li> pom.xml in the main slib directory to change the version of the modified library
</ul>

To install the library in the local repository the following command has been run from the slib directory where the pom.xml of the parent project is located:
/code{ mvn clean install }

A Similarity.java class has been created to compute load OBO ontologies into a graph, to configure the similarity measure and to compute the semantic similarity between two concepts (pairwise similarity) or two sets of concepts (groupwise similarity)

To create a unique jar with all the dependencies we used maven as follows:
/code{mvn clean install  assembly:single}
This two libraries will be used in the package Onassis
}
