/*
 * Decompiled with CFR 0.152.
 */
package slib.utils.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import slib.utils.ex.SLIB_Ex_Critic;

public class MatrixDouble<C, R> {
    private Map<C, Integer> columnIndex;
    private Map<R, Integer> rowIndex;
    private Double[][] matrix;
    private int columns_number;
    private int rows_number;

    public MatrixDouble(Set<C> columResources, Set<R> rowResources) {
        this.init(columResources, rowResources);
    }

    public MatrixDouble(Set<C> columResources, Set<R> rowResources, Double initValue) {
        this.init(columResources, rowResources);
        if (initValue != null) {
            for (Double[] mat : this.matrix) {
                for (int j = 0; j < mat.length; ++j) {
                    mat[j] = initValue;
                }
            }
        }
    }

    private void init(Set<C> columResources, Set<R> rowResources) {
        this.columns_number = columResources.size();
        this.rows_number = rowResources.size();
        this.columnIndex = new HashMap<C, Integer>(this.columns_number);
        this.rowIndex = new HashMap<R, Integer>(this.rows_number);
        this.matrix = new Double[this.columns_number][this.rows_number];
        int id = 0;
        for (Object rc : columResources) {
            this.columnIndex.put(rc, id);
            ++id;
        }
        id = 0;
        for (Object rc : rowResources) {
            this.rowIndex.put(rc, id);
            ++id;
        }
    }

    public Double[] getColumn(C r) {
        if (this.isInColumnIndex(r)) {
            return this.matrix[this.columnIndex.get(r)];
        }
        return null;
    }

    public Double[] getRow(R r) {
        if (!this.isInRowIndex(r)) {
            return null;
        }
        Double[] row = new Double[this.columns_number];
        int row_resource_id = this.rowIndex.get(r);
        for (int j = 0; j < this.columns_number; ++j) {
            row[j] = this.matrix[j][row_resource_id];
        }
        return row;
    }

    public Double getValueCheckIndex(C colResource, R rowResource) {
        if (this.isInColumnIndex(colResource) && this.isInRowIndex(rowResource)) {
            return this.matrix[this.columnIndex.get(colResource)][this.rowIndex.get(rowResource)];
        }
        return null;
    }

    public Double getValue(C colResource, R rowResource) throws SLIB_Ex_Critic {
        try {
            return this.matrix[this.columnIndex.get(colResource)][this.rowIndex.get(rowResource)];
        }
        catch (Exception e) {
            throw new SLIB_Ex_Critic("Undefined index contains col index " + colResource + " " + this.isInColumnIndex(colResource) + "\ncontains row index " + rowResource + " " + this.isInRowIndex(rowResource) + " in matrix " + e.getMessage());
        }
    }

    public void setValue(C colResource, R rowResource, Double value) {
        this.matrix[this.columnIndex.get(colResource).intValue()][this.rowIndex.get(rowResource).intValue()] = value;
    }

    public boolean isInRowIndex(R r) {
        return this.rowIndex.keySet().contains(r);
    }

    public boolean isInColumnIndex(C r) {
        return this.columnIndex.keySet().contains(r);
    }

    public int getNbColumns() {
        return this.columns_number;
    }

    public int getNbRows() {
        return this.rows_number;
    }

    public boolean isSquare() {
        return this.rows_number == this.columns_number;
    }

    public Double getMax() {
        Double max = null;
        for (Double[] mat : this.matrix) {
            for (int j = 0; j < this.matrix[0].length; ++j) {
                if (mat[j] == null || max != null && !(mat[j] > max)) continue;
                max = mat[j];
            }
        }
        return max;
    }

    public Double getMaxColumn(C v) {
        if (!this.isInColumnIndex(v)) {
            throw new IllegalArgumentException("Unable to locate " + v + "in the column index");
        }
        Double[] columnScore = this.getColumn(v);
        Double max = null;
        for (int i = 0; i < this.rows_number; ++i) {
            if (columnScore[i] == null || max != null && !(max < columnScore[i])) continue;
            max = columnScore[i];
        }
        return max;
    }

    public Double getMaxRow(R v) {
        if (!this.isInRowIndex(v)) {
            throw new IllegalArgumentException("Unable to locate " + v + "in the row index");
        }
        Double[] rowScore = this.getRow(v);
        Double max = null;
        for (int i = 0; i < this.columns_number; ++i) {
            if (rowScore[i] == null || max != null && !(max < rowScore[i])) continue;
            max = rowScore[i];
        }
        return max;
    }

    public Double getMin() {
        Double min = null;
        Double[][] doubleArray = this.matrix;
        int n = doubleArray.length;
        for (int i = 0; i < n; ++i) {
            Double[] row;
            for (Double v : row = doubleArray[i]) {
                if (v == null || min != null && !(v < min)) continue;
                min = v;
            }
        }
        return min;
    }

    public Double getAverage() {
        Double sum = 0.0;
        double count = 0.0;
        Double[][] doubleArray = this.matrix;
        int n = doubleArray.length;
        for (int i = 0; i < n; ++i) {
            Double[] row;
            for (Double v : row = doubleArray[i]) {
                if (v == null) continue;
                sum = sum + v;
                count += 1.0;
            }
        }
        if (count == 0.0) {
            return null;
        }
        return sum / count;
    }

    public Double[][] getMatrix() {
        return this.matrix;
    }

    public String toString() {
        String out = "";
        for (C v : this.columnIndex.keySet()) {
            out = out + "\t" + v.toString();
        }
        out = out + "\n";
        for (Object vj : this.rowIndex.keySet()) {
            out = out + vj.toString();
            for (C v : this.columnIndex.keySet()) {
                try {
                    out = out + "\t" + this.getValue(v, vj);
                }
                catch (SLIB_Ex_Critic e) {
                    throw new RuntimeException("Ooops an error occur in Matrix class");
                }
            }
            out = out + "\n";
        }
        out = out + "\n";
        return out;
    }

    public Set<C> getColumnElements() {
        return this.columnIndex.keySet();
    }

    public Set<R> getRowElements() {
        return this.rowIndex.keySet();
    }

    public Double getSum() {
        double sum = 0.0;
        boolean touched = false;
        Double[][] doubleArray = this.matrix;
        int n = doubleArray.length;
        for (int i = 0; i < n; ++i) {
            Double[] row;
            for (Double v : row = doubleArray[i]) {
                if (v == null) continue;
                sum += v.doubleValue();
                touched = true;
            }
        }
        if (touched) {
            return sum;
        }
        return null;
    }
}

