/*
 * Decompiled with CFR 0.152.
 */
package slib.graph.io.loader.utils.filter.graph.repo;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import slib.graph.io.loader.utils.filter.graph.Filter;
import slib.utils.ex.SLIB_Ex_Critic;

public class FilterRepository {
    private static FilterRepository instance;
    public Map<String, Filter> filters = new HashMap<String, Filter>();

    public static FilterRepository getInstance() {
        if (instance == null) {
            instance = new FilterRepository();
        }
        return instance;
    }

    private FilterRepository() {
    }

    public Filter getFilter(String name) {
        return this.filters.get(name);
    }

    public Set<Filter> getFilters() {
        return new HashSet<Filter>(this.filters.values());
    }

    public void addFilter(Filter f) throws SLIB_Ex_Critic {
        if (this.filters.containsKey(f.getId())) {
            throw new SLIB_Ex_Critic("Duplicate filter " + f.getId());
        }
        this.filters.put(f.getId(), f);
    }

    public Filter containsFilter(String fname) throws SLIB_Ex_Critic {
        return this.filters.get(fname);
    }

    public void clear() {
        this.filters.clear();
    }
}

