/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.federation.optimizers;

import java.util.List;
import org.openrdf.query.algebra.BinaryTupleOperator;
import org.openrdf.query.algebra.EmptySet;
import org.openrdf.query.algebra.Join;
import org.openrdf.query.algebra.LeftJoin;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.SingletonSet;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;
import org.openrdf.sail.federation.algebra.NaryJoin;

public class EvaluationStatistics {
    protected CardinalityCalculator calculator;
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getCardinality(TupleExpr expr) {
        Object object = this.lock;
        synchronized (object) {
            if (this.calculator == null) {
                this.calculator = this.createCardinalityCalculator();
            }
            expr.visit(this.calculator);
            return this.calculator.getCardinality();
        }
    }

    protected CardinalityCalculator createCardinalityCalculator() {
        return new CardinalityCalculator();
    }

    protected static class CardinalityCalculator
    extends QueryModelVisitorBase<RuntimeException> {
        protected double cardinality;

        protected CardinalityCalculator() {
        }

        public double getCardinality() {
            return this.cardinality;
        }

        @Override
        public void meet(EmptySet node) {
            this.cardinality = 0.0;
        }

        @Override
        public void meet(SingletonSet node) {
            this.cardinality = 1.0;
        }

        @Override
        public void meet(StatementPattern pattern) {
            this.cardinality = this.getCardinality(pattern);
        }

        protected double getCardinality(StatementPattern pattern) {
            List<Var> vars = pattern.getVarList();
            int constantVarCount = this.countConstantVars(vars);
            double unboundVarFactor = (double)(vars.size() - constantVarCount) / (double)vars.size();
            return Math.pow(1000.0, unboundVarFactor);
        }

        protected int countConstantVars(Iterable<Var> vars) {
            int constantVarCount = 0;
            for (Var var : vars) {
                if (!var.hasValue()) continue;
                ++constantVarCount;
            }
            return constantVarCount;
        }

        @Override
        public void meetOther(QueryModelNode node) {
            if (node instanceof NaryJoin) {
                this.meetMultiJoin((NaryJoin)node);
            } else {
                super.meetOther(node);
            }
        }

        public void meetMultiJoin(NaryJoin node) {
            double cost = 1.0;
            for (TupleExpr arg : node.getArgs()) {
                arg.visit(this);
                cost *= this.cardinality;
            }
            this.cardinality = cost;
        }

        @Override
        public void meet(Join node) {
            double cost = 1.0;
            for (TupleExpr arg : new TupleExpr[]{node.getLeftArg(), node.getRightArg()}) {
                arg.visit(this);
                cost *= this.cardinality;
            }
            this.cardinality = cost;
        }

        @Override
        public void meet(LeftJoin node) {
            node.getLeftArg().visit(this);
            double leftArgCost = this.cardinality;
            node.getRightArg().visit(this);
            this.cardinality *= leftArgCost;
        }

        @Override
        protected void meetBinaryTupleOperator(BinaryTupleOperator node) {
            double cost = 0.0;
            for (TupleExpr arg : new TupleExpr[]{node.getLeftArg(), node.getRightArg()}) {
                arg.visit(this);
                cost += this.cardinality;
            }
            this.cardinality = cost;
        }
    }
}

