/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.contextaware.config;

import org.openrdf.repository.Repository;
import org.openrdf.repository.config.RepositoryConfigException;
import org.openrdf.repository.config.RepositoryFactory;
import org.openrdf.repository.config.RepositoryImplConfig;
import org.openrdf.repository.contextaware.ContextAwareRepository;
import org.openrdf.repository.contextaware.config.ContextAwareConfig;

public class ContextAwareFactory
implements RepositoryFactory {
    public static final String REPOSITORY_TYPE = "openrdf:ContextAwareRepository";

    @Override
    public String getRepositoryType() {
        return REPOSITORY_TYPE;
    }

    @Override
    public RepositoryImplConfig getConfig() {
        return new ContextAwareConfig();
    }

    @Override
    public Repository getRepository(RepositoryImplConfig configuration) throws RepositoryConfigException {
        if (configuration instanceof ContextAwareConfig) {
            ContextAwareConfig config = (ContextAwareConfig)configuration;
            ContextAwareRepository repo = new ContextAwareRepository();
            repo.setIncludeInferred(config.isIncludeInferred());
            repo.setMaxQueryTime(config.getMaxQueryTime());
            repo.setQueryLanguage(config.getQueryLanguage());
            repo.setBaseURI(config.getBaseURI());
            repo.setReadContexts(config.getReadContexts());
            repo.setAddContexts(config.getAddContexts());
            repo.setRemoveContexts(config.getRemoveContexts());
            repo.setArchiveContexts(config.getArchiveContexts());
            repo.setInsertContext(config.getInsertContext());
            return repo;
        }
        throw new RepositoryConfigException("Invalid configuration class: " + configuration.getClass());
    }
}

