/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.parser.serql;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.parser.ParsedGraphQuery;
import org.openrdf.query.parser.ParsedQuery;
import org.openrdf.query.parser.ParsedTupleQuery;
import org.openrdf.query.parser.ParsedUpdate;
import org.openrdf.query.parser.QueryParser;
import org.openrdf.query.parser.serql.AnonymousVarGenerator;
import org.openrdf.query.parser.serql.NamespaceDeclProcessor;
import org.openrdf.query.parser.serql.NullProcessor;
import org.openrdf.query.parser.serql.ProjectionAliasProcessor;
import org.openrdf.query.parser.serql.ProjectionProcessor;
import org.openrdf.query.parser.serql.QueryModelBuilder;
import org.openrdf.query.parser.serql.StringEscapesProcessor;
import org.openrdf.query.parser.serql.ast.ASTGraphQuery;
import org.openrdf.query.parser.serql.ast.ASTQuery;
import org.openrdf.query.parser.serql.ast.ASTQueryContainer;
import org.openrdf.query.parser.serql.ast.ASTTupleQuery;
import org.openrdf.query.parser.serql.ast.ParseException;
import org.openrdf.query.parser.serql.ast.SyntaxTreeBuilder;
import org.openrdf.query.parser.serql.ast.TokenMgrError;
import org.openrdf.query.parser.serql.ast.VisitorException;

public class SeRQLParser
implements QueryParser {
    @Override
    public ParsedQuery parseQuery(String queryStr, String baseURI) throws MalformedQueryException {
        try {
            ParsedQuery query;
            ASTQueryContainer qc = SyntaxTreeBuilder.parseQuery(queryStr);
            NullProcessor.process(qc);
            StringEscapesProcessor.process(qc);
            Map<String, String> namespaces = NamespaceDeclProcessor.process(qc);
            ProjectionProcessor.process(qc);
            qc.jjtAccept(new ProjectionAliasProcessor(), null);
            qc.jjtAccept(new AnonymousVarGenerator(), null);
            TupleExpr tupleExpr = QueryModelBuilder.buildQueryModel(qc, new ValueFactoryImpl());
            ASTQuery queryNode = qc.getQuery();
            if (queryNode instanceof ASTTupleQuery) {
                query = new ParsedTupleQuery(tupleExpr);
            } else if (queryNode instanceof ASTGraphQuery) {
                query = new ParsedGraphQuery(tupleExpr, namespaces);
            } else {
                throw new RuntimeException("Unexpected query type: " + queryNode.getClass());
            }
            return query;
        }
        catch (ParseException e) {
            throw new MalformedQueryException(e.getMessage(), e);
        }
        catch (TokenMgrError e) {
            throw new MalformedQueryException(e.getMessage(), e);
        }
        catch (VisitorException e) {
            throw new MalformedQueryException(e.getMessage(), e);
        }
    }

    public static void main(String[] args) throws IOException {
        System.out.println("Your SeRQL query:");
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        StringBuilder buf = new StringBuilder();
        String line = null;
        while ((line = in.readLine()) != null) {
            if (line.length() > 0) {
                buf.append(' ').append(line).append('\n');
                continue;
            }
            String queryStr = buf.toString().trim();
            if (queryStr.length() > 0) {
                try {
                    SeRQLParser parser = new SeRQLParser();
                    parser.parseQuery(queryStr, null);
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                    e.printStackTrace();
                }
            }
            buf.setLength(0);
        }
    }

    @Override
    public ParsedUpdate parseUpdate(String updateStr, String baseURI) throws MalformedQueryException {
        throw new UnsupportedOperationException("SeRQL does not support update operations");
    }
}

