/*
 * Decompiled with CFR 0.152.
 */
package iit.comp.epigen.nlp.similarity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.openrdf.model.URI;
import slib.graph.algo.extraction.validator.dag.ValidatorDAG;
import slib.graph.algo.utils.GAction;
import slib.graph.algo.utils.GActionType;
import slib.graph.algo.utils.GraphActionExecutor;
import slib.graph.io.conf.GDataConf;
import slib.graph.io.conf.GraphConf;
import slib.graph.io.loader.GraphLoaderGeneric;
import slib.graph.io.util.GFormat;
import slib.graph.model.graph.G;
import slib.graph.model.impl.graph.memory.GraphMemory;
import slib.graph.model.impl.repo.URIFactoryMemory;
import slib.sml.sm.core.engine.SM_Engine;
import slib.sml.sm.core.metrics.ic.utils.IC_Conf_Corpus;
import slib.sml.sm.core.metrics.ic.utils.IC_Conf_Topo;
import slib.sml.sm.core.metrics.ic.utils.ICconf;
import slib.sml.sm.core.utils.SMConstants;
import slib.sml.sm.core.utils.SMconf;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.ex.SLIB_Exception;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Similarity {
    public G loadOntology(String ontologyPath) throws SLIB_Exception {
        URIFactoryMemory factory = URIFactoryMemory.getSingleton();
        URI graphURI = factory.getURI("http://graph/");
        GraphMemory g = new GraphMemory(graphURI);
        GDataConf dataConf = "obo".equals(FilenameUtils.getExtension(ontologyPath)) ? new GDataConf(GFormat.OBO, ontologyPath) : new GDataConf(GFormat.RDF_XML, ontologyPath);
        GraphConf gConf = new GraphConf();
        gConf.addGDataConf(dataConf);
        GraphLoaderGeneric.populate(dataConf, g);
        GAction predicateSubstitute = new GAction(GActionType.PREDICATE_SUBSTITUTE);
        predicateSubstitute.addParameter("old_uri", "http://graph/part_of");
        predicateSubstitute.addParameter("new_uri", "RDFS.SUBCLASSOF");
        GraphActionExecutor.applyAction(predicateSubstitute, g);
        predicateSubstitute = new GAction(GActionType.PREDICATE_SUBSTITUTE);
        predicateSubstitute.addParameter("old_uri", "http://graph/develops_from");
        predicateSubstitute.addParameter("new_uri", "RDFS.SUBCLASSOF");
        GraphActionExecutor.applyAction(predicateSubstitute, g);
        Set<URI> roots = new ValidatorDAG().getTaxonomicRoots(g);
        if (roots.size() > 1) {
            GAction actionRerootConf = new GAction(GActionType.REROOTING);
            GraphActionExecutor.applyAction(actionRerootConf, g);
        }
        return g;
    }

    public SMconf setPairwiseConfig(String pairwiseShortFlag, String icConfShortFlag) throws SLIB_Ex_Critic {
        String pairwise = SMConstants.SIM_PAIRWISE_SHORT_FLAG.get(pairwiseShortFlag);
        SMconf config = new SMconf(pairwise);
        if (!pairwise.contains("_EDGE")) {
            ICconf icConf = null;
            if (SMConstants.IC_SHORT_FLAG.get(icConfShortFlag) != null) {
                icConf = !SMConstants.IC_SHORT_FLAG.get(icConfShortFlag).contains("_annot") ? new IC_Conf_Topo(SMConstants.IC_SHORT_FLAG.get(icConfShortFlag)) : new IC_Conf_Corpus(SMConstants.IC_SHORT_FLAG.get(icConfShortFlag));
                config.setICconf(icConf);
            } else {
                icConf = new IC_Conf_Topo(SMConstants.IC_SHORT_FLAG.get("resnik"));
            }
        }
        return config;
    }

    public SMconf setGroupwiseConfig(String groupwiseShortFlag) throws SLIB_Ex_Critic {
        String groupwise = SMConstants.SIM_GROUPWISE_SHORT_FLAG.get(groupwiseShortFlag);
        SMconf config = new SMconf(groupwise);
        return config;
    }

    public ArrayList<Set<String>> showMeasures() throws SLIB_Ex_Critic {
        Set<String> pairwise = SMConstants.SIM_PAIRWISE_SHORT_FLAG.keySet();
        Set<String> infoContent = SMConstants.IC_SHORT_FLAG.keySet();
        Set<String> groupWiseIt = SMConstants.SIM_GROUPWISE_SHORT_FLAG.keySet();
        ArrayList<Set<String>> optionsList = new ArrayList<Set<String>>();
        optionsList.add(pairwise);
        optionsList.add(infoContent);
        optionsList.add(groupWiseIt);
        return optionsList;
    }

    public Map<String, SMconf> getAllGroupwiseMeasures() throws SLIB_Ex_Critic {
        Iterator<Map.Entry<String, String>> groupwiseIt = SMConstants.SIM_GROUPWISE_SHORT_FLAG.entrySet().iterator();
        HashMap<String, SMconf> configurations = new HashMap<String, SMconf>();
        while (groupwiseIt.hasNext()) {
            Map.Entry<String, String> pair = groupwiseIt.next();
            SMconf config = new SMconf(pair.getValue().toString());
            configurations.put(pair.getKey().toString(), config);
        }
        return configurations;
    }

    public Map<String, SMconf> getAllPairwiseCombinations() throws SLIB_Ex_Critic {
        Iterator<Map.Entry<String, String>> pairwiseIt = SMConstants.SIM_PAIRWISE_SHORT_FLAG.entrySet().iterator();
        HashMap<String, SMconf> configurations = new HashMap<String, SMconf>();
        while (pairwiseIt.hasNext()) {
            Map.Entry<String, String> pair = pairwiseIt.next();
            SMconf config = new SMconf(pair.getValue().toString());
            if (!pair.getValue().toString().contains("_EDGE")) {
                for (Map.Entry<String, String> icPair : SMConstants.IC_SHORT_FLAG.entrySet()) {
                    ICconf icConf = null;
                    String confStringIC = icPair.getValue().toString();
                    icConf = !confStringIC.contains("_annot") ? new IC_Conf_Topo(SMConstants.IC_SHORT_FLAG.get(icPair.getKey())) : new IC_Conf_Corpus(SMConstants.IC_SHORT_FLAG.get(icPair.getKey()));
                    if (icConf == null) continue;
                    config.setICconf(icConf);
                    configurations.put(String.valueOf(pair.getValue().toString()) + "___________" + confStringIC, config);
                }
                continue;
            }
            configurations.put(pair.getValue().toString(), config);
        }
        return configurations;
    }

    public double group_similarity(Set<URI> firstURIset, Set<URI> secondURIset, G graph, SMconf groupConfig, SMconf pairConfig) throws SLIB_Ex_Critic {
        double score = 0.0;
        if (groupConfig.getId().equals("SIM_GROUPWISE_BMA") || groupConfig.getId().equals("SIM_GROUPWISE_MIN") || groupConfig.getId().equals("SIM_GROUPWISE_AVERAGE") || groupConfig.getId().equals("SIM_GROUPWISE_MAX") || groupConfig.getId().equals("SIM_GROUPWISE_BMA") || groupConfig.getId().equals("SIM_GROUPWISE_BMM")) {
            try {
                SM_Engine engine = new SM_Engine(graph);
                score = engine.compare(groupConfig, pairConfig, firstURIset, secondURIset);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                SM_Engine engine = new SM_Engine(graph);
                score = engine.compare(groupConfig, firstURIset, secondURIset);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return score;
    }

    public double pair_similarity(URI firstURI, URI secondURI, G graph, SMconf pairConfig) throws SLIB_Ex_Critic {
        double score = 0.0;
        SM_Engine engine = new SM_Engine(graph);
        score = engine.compare(pairConfig, firstURI, secondURI);
        return score;
    }

    public Map<String, Double> pairWiseCompareAll(URI firstURI, URI secondURI, G graph) throws SLIB_Ex_Critic {
        Map<String, SMconf> configs = this.getAllPairwiseCombinations();
        Iterator<Map.Entry<String, SMconf>> it = configs.entrySet().iterator();
        HashMap<String, Double> results = new HashMap<String, Double>();
        while (it.hasNext()) {
            Map.Entry<String, SMconf> conf_pair = it.next();
            double score = this.pair_similarity(firstURI, secondURI, graph, conf_pair.getValue());
            results.put(conf_pair.getKey().toString(), new Double(score));
        }
        return results;
    }

    public Map<String, Double> groupWiseCompareAll(Set<URI> firstGroup, Set<URI> secondGroup, G graph) throws SLIB_Ex_Critic {
        Map<String, SMconf> groupConf = this.getAllGroupwiseMeasures();
        Map<String, SMconf> pairConf = this.getAllPairwiseCombinations();
        HashMap<String, Double> results = new HashMap<String, Double>();
        for (Map.Entry<String, SMconf> group_conf : groupConf.entrySet()) {
            for (Map.Entry<String, SMconf> pair_conf : groupConf.entrySet()) {
                double score = this.group_similarity(firstGroup, secondGroup, graph, group_conf.getValue(), pair_conf.getValue());
                results.put(String.valueOf(group_conf.getKey().toString()) + "_" + pair_conf.getKey().toString(), score);
            }
        }
        return results;
    }

    public Set<URI> createURIs(String[] terms) {
        URIFactoryMemory factory = URIFactoryMemory.getSingleton();
        HashSet<URI> uriList = new HashSet<URI>();
        String[] stringArray = terms;
        int n = terms.length;
        int n2 = 0;
        while (n2 < n) {
            String term = stringArray[n2];
            URI termURI = factory.getURI(term);
            uriList.add(termURI);
            ++n2;
        }
        return uriList;
    }

    public URI createURI(String term) {
        URIFactoryMemory factory = URIFactoryMemory.getSingleton();
        URI termURI = factory.getURI(term);
        return termURI;
    }

    public static void main(String[] args) {
        Similarity sim = new Similarity();
        try {
            URIFactoryMemory factory = URIFactoryMemory.getSingleton();
            String filePath = "BrendaTissue.obo";
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            filePath = classLoader.getResource(filePath).getFile();
            G graph = sim.loadOntology(filePath);
            System.out.println(graph.toString());
            System.out.println(graph.getE().toString());
            SM_Engine engine = new SM_Engine(graph);
            URI bto1 = factory.getURI("http://purl.obolibrary.org/obo/BTO_0004732");
            URI bto2 = factory.getURI("http://purl.obolibrary.org/obo/BTO_0000801");
            URI bto3 = factory.getURI("http://purl.obolibrary.org/obo/BTO_0000815");
            URI bto4 = factory.getURI("http://purl.obolibrary.org/obo/BTO_0001912");
            HashSet<URI> bto1e2 = new HashSet<URI>();
            bto1e2.add(bto1);
            bto1e2.add(bto2);
            HashSet<URI> bto3e4 = new HashSet<URI>();
            bto3e4.add(bto3);
            bto3e4.add(bto4);
            SMconf configMconf = sim.setPairwiseConfig("edge_li", null);
            System.out.println(configMconf.toString());
            double score = sim.pair_similarity(bto2, bto3, graph, configMconf);
            SMconf group = sim.setGroupwiseConfig("bma");
            double score2 = sim.group_similarity(bto1e2, bto3e4, graph, group, configMconf);
            System.out.println("Primo " + score + "\n Secondo " + score2);
        }
        catch (SLIB_Exception e) {
            e.printStackTrace();
        }
    }
}

