\name{H1.WGBS}
\alias{H1.WGBS}
\docType{data}
\title{
  BS-seq data of H1 cell line
}
\description{
  BS-seq data of H1 cell line from Lister et al. 2009
}
\details{
  This is the BS-seq dataset of H1 cell line (Lister et al. 2009).
  The dataset has been stored in BSdata class of package methylPipe
  and can directly be used for further analysis using the package.
}
\examples{
library(BSgenome.Hsapiens.UCSC.hg18)
h1data <- system.file('extdata', 'mc_h1_tabix.txt.gz', package='ListerEtAlBSseq')
h1uncov <- system.file('extdata', 'uncov_GR_h1.Rdata', package='ListerEtAlBSseq')
load(h1uncov)
H1.WGBS <- BSdata(file=h1data, uncov=uncov_GR_h1, org=Hsapiens)
}
\keyword{datasets}
