% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_long_data.R
\name{get_long_data}
\alias{get_long_data}
\title{Create a long data.frame from a MultiAssayExperiment counts object}
\usage{
get_long_data(dat, taxon_level, log = FALSE, counts_to_CPM = FALSE)
}
\arguments{
\item{dat}{A \code{MultiAssayExperiment} object specially formatted as an
animalcules output.}

\item{taxon_level}{Character string indicating the level of taxonomy to
aggregate the counts data. Must be the name of a column in
\code{MultiAssayExperiment::rowData(dat)}.}

\item{log}{logical. Indicate whether an assay returned should be the log of
whichever assay is specified in \code{"output_name"}. If
\code{counts_to_CPM = TRUE} as well, then a log CPM assay will also be
created. Default is \code{FALSE}.}

\item{counts_to_CPM}{logical. This argument only applies if the
\code{input_type} is a counts assay. If \code{TRUE}, then the output assays
will include a normalized CPM assay. If \code{log = TRUE} as well, then a
log CPM assay will also be created. Default is \code{TRUE}.}
}
\value{
A \code{data.frame} consisting of the counts data, taxa, and
  metadata.
}
\description{
This function takes a \code{MultiAssayExperiment} object and a specified
taxon level of interest and creates a long \code{data.frame} that can be used
more easily for plotting counts data.
}
\examples{
in_dat <- system.file("extdata/MAE_small.RDS", package = "LegATo") |> readRDS()
out <- get_long_data(in_dat, "genus", log = TRUE, counts_to_CPM = TRUE)
head(out)

}
