% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_phosphopeptides.R
\name{processPhosphopeptides}
\alias{processPhosphopeptides}
\title{processPhosphopetides}
\usage{
processPhosphopeptides(
  sites,
  onlyCentralAcceptor = TRUE,
  allowPhosphoPriming = TRUE,
  upstream = 5L,
  downstream = 5L
)
}
\arguments{
\item{sites}{Character vector with phospho-peptides}

\item{onlyCentralAcceptor}{Process only the central phospho-acceptor residue?}

\item{allowPhosphoPriming}{Allow phospho-acceptors at non-central positions?
These should be indicated by the lower case letters s, t or y.}

\item{upstream}{Number of bases upstream of central phospho-acceptor in the
processed output}

\item{downstream}{Number of bases downstream of central phospho-acceptor in
the processed output}
}
\value{
A tibble with columns: \code{sites}, \code{processed}, \code{acceptor}
}
\description{
Process phospho-peptides to a common format used for PWM matching
}
\details{
Phosphorylated residues are recognized either by lower case letters (s, t or
y) or the phosphorylated residue is followed by an asterisk (S*, T* or Y*).

If a peptide reports several phosphorylated residues, parameter
\code{onlyCentralAcceptor} allows for two processing options: (1) By default, only
the central phospho-acceptor of each phospho-peptide is considered. Here
central is defined as the left-closest position to \code{floor(nchar(site)/2)+1}.
(2) All phospho-acceptors are considered as central in which case the
phospho-peptide is replicated and aligned for each of its phosphorylated
residues. In this case the output sites are not in parallel to the input
peptides.

In both cases, non-central phospho-acceptors are indicated by lower case
letters (s, t, or y). These residues enable phospho-priming of the site. If
phospho-priming is disabled (parameter \code{allowPhosphoPriming}) these residues
are converted to upper case letters.

If a site does not follow the phosphorylation patterns described above, the
central residue defined by position \code{floor(nchar(site)/2)+1} is considered
the default phospho-acceptor site.

The input sites are truncated and/or padded such that the processed sites are
of width \code{upstream}+\code{downstream}+1. By default the central phospho-acceptor
is surrounded by 5 upstream and 5 downstream residues.

A warning is raised if the central phospho-acceptor is not serine, threonine
or tyrosine.
}
\examples{
procSites <- processPhosphopeptides(c("AGLLS*DEDC", "RtEKGS*N", "ETGKDN"))
}
