% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HiBED_deconvolution.R
\name{HiBED_deconvolution}
\alias{HiBED_deconvolution}
\title{HiBED_deconvolution}
\usage{
HiBED_deconvolution(Beta, h = 2)
}
\arguments{
\item{Beta}{Methylation beta in the format of matrix or data frame or Mset or
SummarizedExperiment from brain samples.}

\item{h}{Numeric variable.
Specify the layer of deconvolution in the hierarchical model. Default is 2.}
}
\value{
A matrix with predicted cell proportions in brain tissues.
}
\description{
The function estimates proportions up to 7 cell types in brain tissues.
}
\examples{
#Step 1: Load required libraries
library(FlowSorted.Blood.EPIC)
library(FlowSorted.DLPFC.450k)
#Step 2: Load example data and preprocess
Mset<-minfi::preprocessRaw(FlowSorted.DLPFC.450k)
Examples_Betas<-minfi::getBeta(Mset)
#Step 3: Run HiBED and show results
HiBED_result<-HiBED_deconvolution(Examples_Betas, h=2)
head(HiBED_result)

}
