\name{Interactions}
\alias{Interactions}
\docType{data}
\title{The genetic interaction data.}
\description{The genetic interaction data. Pairwise interaction scores (\code{piscore}) are presented in a 6-dimensional array with dimensions target genes x target siRNA designs x query genes x query siRNA designs x features x replicates. BH-corrected p-values ({padj}) are presented in a 5-dimensional array with dimensions target genes x target siRNA designs x query genes x query siRNA designs x features. An annotation of target and query genes and of phenotypes can be found in (\code{Anno}). \code{scale} is the standard deviation measure used for normalization. At first standard deviations were computed between replicates for each experiment and afterwards the median of standard deviations was computed.}
\usage{data(Interactions)}
\format{
  The format is:
List of 4
 $ piscore: num [1:282, 1:2, 1:20, 1:2, 1:11, 1:2] -1.814 -2.457 -3.094 -1.448 -0.142 ...
  ..- attr(*, "dimnames")=List of 6
  .. ..$ targetGene  : chr [1:282] "TDRD6" "PRDM11" "KDM1B" "INTS12" ...
  .. ..$ targetDesign: chr [1:2] "1" "2"
  .. ..$ queryGene     : chr [1:20] "DPF2" "SMARCA1" "SMARCC1" "SMARCD2" ...
  .. ..$ queryDesign   : chr [1:2] "1" "2"
  .. ..$ features      : chr [1:11] "count" "cell.act.m.majoraxis" "nuc.nuc.b.q001" "nuc.0.m.eccentricity" ...
  .. ..$ replicate     : chr [1:2] "1" "2"
 $ scale     : num [1:11] 0.214 0.125 0.139 0.193 0.207 ...
 $ padj      : num [1:282, 1:2, 1:20, 1:2, 1:11] 0.6838 0.4167 0.0949 0.5786 0.7933 ...
  ..- attr(*, "dimnames")=List of 5
  .. ..$ targetGene  : chr [1:282] "TDRD6" "PRDM11" "KDM1B" "INTS12" ...
  .. ..$ targetDesign: chr [1:2] "1" "2"
  .. ..$ queryGene     : chr [1:20] "DPF2" "SMARCA1" "SMARCC1" "SMARCD2" ...
  .. ..$ queryDesign   : chr [1:2] "1" "2"
  .. ..$ features      : chr [1:11] "count" "cell.act.m.majoraxis" "nuc.nuc.b.q001" "nuc.0.m.eccentricity" ...
 $ Anno      :List of 3
  ..$ target :'data.frame':	282 obs. of  4 variables:
  .. ..$ ID    : chr [1:282] "B1" "B2" "B3" "B4" ...
  .. ..$ Symbol: chr [1:282] "TDRD6" "PRDM11" "KDM1B" "INTS12" ...
  .. ..$ Well  : chr [1:282] "B1" "B2" "B3" "B4" ...
  .. ..$ group : chr [1:282] "sample" "sample" "sample" "sample" ...
  ..$ query    :'data.frame':	20 obs. of  2 variables:
  .. ..$ ID    : chr [1:20] "01" "02" "03" "04" ...
  .. ..$ Symbol: chr [1:20] "DPF2" "SMARCA1" "SMARCC1" "SMARCD2" ...
  ..$ phenotype: chr [1:11] "count" "cell.act.m.majoraxis" "nuc.nuc.b.q001" "nuc.0.m.eccentricity" ...
}
\references{Laufer, Fischer et al., 2013}
\seealso{
\code{\link{HD2013SGI}}
}
\examples{
data(Interactions, package="HD2013SGI")
plot(Interactions$piscore[,1,"SUV39H1",1,"cell.act.m.majoraxis",1])
print(names(which(Interactions$padj[,1,"SUV39H1",1,
                                    "cell.act.m.majoraxis"] <= 0.01)))
}
\keyword{datasets}
