% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_DoReMiTra_data.R
\name{get_DoReMiTra_data}
\alias{get_DoReMiTra_data}
\title{Fetch a selected dataset from the DoReMiTra collection}
\usage{
get_DoReMiTra_data(dataset_name, gene_symbol = FALSE)
}
\arguments{
\item{dataset_name}{Character. The exact name of the dataset (e.g. "SE_Amundson_2008_ExVivo_GSE8917_GPL1708").}

\item{gene_symbol}{Logical. default is FALSE. If TRUE, gene symbol will be assigned to rownames.
If some gene symbols were found to be duplicated, gene symbol and the corresponding probe id will be appended together.}
}
\value{
A \code{SummarizedExperiment} object fetched from ExperimentHub.
}
\description{
This function fetches a \code{SummarizedExperiment} object from ExperimentHub
corresponding to a dataset in the DoReMiTra package.
}
\examples{
get_DoReMiTra_data("SE_Amundson_2008_ExVivo_GSE8917_GPL1708")

}
