## ----load hub, results='hide'-------------------------------------------------
library(ExperimentHub, quietly = TRUE)

## ----setup--------------------------------------------------------------------
hub <- ExperimentHub()
eh <- query(hub, "CENTREprecomputed")
eh

## ----CENTREprecompDb object---------------------------------------------------
library(CENTREprecomputed)
centreprecompdb <- eh[["EH9540"]]

## ----how to fetch data--------------------------------------------------------
# get all tables and their columns, won't show metadata table
tables(centreprecompdb)
# Select all cor_CRUP coefficients of enhancer EH38E3440167. Return the pair
# and ID column
fetch_data_precomp(centreprecompdb,
    table = "crup_cor",
    columns = c("pair", "cor_CRUP"),
    entries = "EH38E3440167",
    column_filter = "symbol38"
)

## ----sessionInfo--------------------------------------------------------------
sessionInfo()

